/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.pase;

import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.menu.LookAndFeelMenu;
import com.ibm.iseries.debug.menu.RecentEnvMenu;
import com.ibm.iseries.debug.menu.RecentPgmMenu;
import com.ibm.iseries.debug.menu.WindowMenu;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.unix.menu.UnixFormatMenu;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PaseMenubar
extends Menubar
implements SettingsListener {
    private DebugContext m_ctxt;
    private LookAndFeelMenu m_lafMenu;
    private RecentEnvMenu m_envMenu;
    private RecentPgmMenu m_pgmMenu;
    private WindowMenu m_wndMenu;

    public void init(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        ActionGroup actionGroup = debugContext.getActionGroup();
        SubMenu subMenu = new SubMenu(MRI.get("DBG_FILE_MENU"));
        this.add(subMenu);
        this.m_lafMenu = new LookAndFeelMenu();
        this.m_envMenu = new RecentEnvMenu(debugContext);
        this.m_pgmMenu = new RecentPgmMenu(debugContext);
        subMenu.addAction(actionGroup, "oenv");
        subMenu.addAction(actionGroup, "senv");
        subMenu.addAction(actionGroup, "senvas");
        subMenu.add(this.m_envMenu);
        subMenu.addSeparator();
        subMenu.add(this.m_pgmMenu);
        subMenu.addSeparator();
        subMenu.addAction(actionGroup, "chgsys");
        subMenu.addSeparator();
        subMenu.addAction(actionGroup, "prefs");
        subMenu.addSeparator();
        subMenu.add(this.m_lafMenu);
        subMenu.addSeparator();
        subMenu.addAction(actionGroup, "close");
        SubMenu subMenu2 = new SubMenu(MRI.get("DBG_EDIT_MENU"));
        this.add(subMenu2);
        subMenu2.addAction(actionGroup, "copy");
        subMenu2.addAction(actionGroup, "cpypnl");
        subMenu2.addSeparator();
        subMenu2.addAction(actionGroup, "find");
        SubMenu subMenu3 = new SubMenu(MRI.get("DBG_DEBUG_MENU"));
        this.add(subMenu3);
        subMenu3.addAction(actionGroup, "strdbg");
        subMenu3.addAction(actionGroup, "enddbg");
        subMenu3.addAction(actionGroup, "rstrdbg");
        subMenu3.addAction(actionGroup, "kill");
        subMenu3.addAction(actionGroup, "dbgopt");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "pauset");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "pause");
        subMenu3.addAction(actionGroup, "resume");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "stepover");
        subMenu3.addAction(actionGroup, "stepoversb");
        subMenu3.addAction(actionGroup, "stepin");
        subMenu3.addAction(actionGroup, "stepout");
        subMenu3.addAction(actionGroup, "stepoutsk");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "rtoc");
        subMenu3.addAction(actionGroup, "rtocsb");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "stepasm");
        subMenu3.addSeparator();
        subMenu3.addAction(actionGroup, "showdsm");
        subMenu3.addAction(actionGroup, "hidedsm");
        SubMenu subMenu4 = new SubMenu(MRI.get("DBG_BREAKPOINT_MENU"));
        this.add(subMenu4);
        subMenu4.addAction(actionGroup, "abrk");
        subMenu4.addAction(actionGroup, "ebrk");
        subMenu4.addAction(actionGroup, "dbrk");
        subMenu4.addSeparator();
        subMenu4.addAction(actionGroup, "rbrk");
        subMenu4.addAction(actionGroup, "rabrk");
        subMenu4.addSeparator();
        subMenu4.addAction(actionGroup, "editbrk");
        subMenu4.addAction(actionGroup, "brkp");
        subMenu4.addSeparator();
        subMenu4.addAction(actionGroup, "addmbrk");
        subMenu4.addSeparator();
        subMenu4.addAction(actionGroup, "ngrp");
        subMenu4.addAction(actionGroup, "dgrp");
        subMenu4.addAction(actionGroup, "grpp");
        SubMenu subMenu5 = new SubMenu(MRI.get("DBG_ACTIONS_MENU"));
        UnixFormatMenu unixFormatMenu = new UnixFormatMenu(actionGroup, true);
        this.add(subMenu5);
        subMenu5.addAction(actionGroup, "dref");
        subMenu5.addAction(actionGroup, "abnds");
        subMenu5.addAction(actionGroup, "reset");
        subMenu5.addSeparator();
        subMenu5.add(unixFormatMenu);
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "newmon");
        subMenu5.addAction(actionGroup, "dltmon");
        subMenu5.addAction(actionGroup, "dltamon");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "rslvsrc");
        subMenu5.addAction(actionGroup, "gosrc");
        subMenu5.addAction(actionGroup, "goline");
        subMenu5.addAction(actionGroup, "gometh");
        subMenu5.addAction(actionGroup, "goaddr");
        subMenu5.addAction(actionGroup, "godsm");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "gotomem");
        subMenu5.addAction(actionGroup, "newmem");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "curthd");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "clrcon");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "supd");
        subMenu5.addAction(actionGroup, "rupd");
        subMenu5.addSeparator();
        subMenu5.addAction(actionGroup, "cols");
        this.m_wndMenu = new WindowMenu(debugContext);
        this.add(this.m_wndMenu);
        SubMenu subMenu6 = new SubMenu(MRI.get("DBG_HELP_PARENT_MENU"));
        this.add(subMenu6);
        subMenu6.addAction(actionGroup, "help");
        subMenu6.addSeparator();
        subMenu6.addAction(actionGroup, "about");
        this.setDefaultEnablement();
        this.m_ctxt.getManager("settmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("settmgr").removeListener(this);
        this.m_lafMenu.cleanUp();
        this.m_envMenu.cleanUp();
        this.m_pgmMenu.cleanUp();
        this.m_wndMenu.cleanUp();
        this.m_ctxt = null;
        this.m_lafMenu = null;
        this.m_envMenu = null;
        this.m_pgmMenu = null;
        this.m_wndMenu = null;
    }

    public void setDefaultEnablement() {
        this.m_envMenu.setEnabled(false);
        this.m_pgmMenu.setEnabled(true);
    }

    public void enableEnvMenu(boolean bl) {
        this.m_envMenu.setEnabled(bl);
    }

    public void enablePgmMenu(boolean bl) {
        this.m_pgmMenu.setEnabled(bl);
    }

    public void refreshWindowMenu() {
        this.m_wndMenu.refresh();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.keysChanged()) {
            int n = this.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                JMenu jMenu = this.getMenu(n2);
                this.updateSubMenu(jMenu);
                ++n2;
            }
        }
    }

    private void updateSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            JMenuItem jMenuItem;
            Action action;
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 instanceof JMenu) {
                this.updateSubMenu((JMenu)jMenuItem2);
            } else if (jMenuItem2 instanceof JMenuItem && (action = (Action)(jMenuItem = jMenuItem2).getAction()) != null) {
                jMenuItem.setAccelerator(action.getKeyStroke());
            }
            ++n2;
        }
    }
}

