/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.pase;

import com.ibm.iseries.debug.BreakpointGroup;
import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.event.BreakpointGroupEvent;
import com.ibm.iseries.debug.listener.BreakpointGroupListener;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class PaseToolbar
extends Toolbar
implements BreakpointGroupListener,
ActionListener {
    private ComboBox m_groupCtrl;
    private ComboRenderer m_renderer;
    private BreakpointGroupManager m_brkgrpMgr;

    public void init(DebugContext debugContext) {
        ActionGroup actionGroup = debugContext.getActionGroup();
        this.addAction(actionGroup, "strdbg");
        this.addAction(actionGroup, "enddbg");
        this.addSeparator();
        this.addAction(actionGroup, "pause");
        this.addAction(actionGroup, "resume");
        this.addSeparator();
        this.addAction(actionGroup, "stepover");
        this.addAction(actionGroup, "stepoversb");
        this.addAction(actionGroup, "stepin");
        this.addAction(actionGroup, "stepout");
        this.addAction(actionGroup, "stepoutsk");
        this.addAction(actionGroup, "rtoc");
        this.addAction(actionGroup, "rtocsb");
        this.addAction(actionGroup, "stepasm");
        this.addSeparator();
        this.addAction(actionGroup, "pauset");
        this.addSeparator();
        this.addAction(actionGroup, "newmon");
        this.addSeparator();
        this.addAction(actionGroup, "abrk");
        this.addAction(actionGroup, "ebrk");
        this.addAction(actionGroup, "dbrk");
        this.addAction(actionGroup, "rbrk");
        this.addAction(actionGroup, "rabrk");
        this.addAction(actionGroup, "ngrp");
        this.addAction(actionGroup, "dgrp");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.addSeparator();
        this.add(jPanel);
        String string = MRI.get("DBG_CURRENT_GROUP");
        this.m_groupCtrl = new ComboBox();
        this.m_renderer = new ComboRenderer();
        this.m_groupCtrl.setAlignmentY(0.5f);
        this.m_groupCtrl.setRenderer(this.m_renderer);
        this.m_groupCtrl.setToolTipText(string);
        this.m_groupCtrl.setMaximumRowCount(20);
        jPanel.add((Component)this.m_groupCtrl, "West");
        Util.setAccessible((Accessible)this.m_groupCtrl, string);
        Util.setOrientation(this.m_groupCtrl);
        this.m_brkgrpMgr = (BreakpointGroupManager)debugContext.getManager("brkgrpmgr");
        this.m_brkgrpMgr.addListener(this);
    }

    public void cleanUp() {
        this.m_brkgrpMgr.removeListener(this);
        this.m_brkgrpMgr = null;
        this.m_groupCtrl = null;
    }

    private void initGroups() {
        this.clearGroups();
        ArrayList arrayList = this.m_brkgrpMgr.getGroups();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)arrayList.get(n2);
            this.m_groupCtrl.addItem(breakpointGroup.getGroupName());
            ++n2;
        }
        this.m_groupCtrl.setSelectedItem(this.m_brkgrpMgr.getCurrentGroupName());
        this.m_groupCtrl.addActionListener(this);
    }

    private void clearGroups() {
        this.m_groupCtrl.removeActionListener(this);
        this.m_groupCtrl.removeAllItems();
    }

    public void breakpointGroupChanged(BreakpointGroupEvent breakpointGroupEvent) {
        switch (breakpointGroupEvent.getType()) {
            case 1: 
            case 3: 
            case 5: {
                this.initGroups();
                break;
            }
            case 2: {
                this.clearGroups();
                break;
            }
            case 4: {
                this.m_groupCtrl.removeActionListener(this);
                this.m_groupCtrl.removeItem(breakpointGroupEvent.getGroup().getGroupName());
                this.m_groupCtrl.setSelectedItem(this.m_brkgrpMgr.getCurrentGroupName());
                this.m_groupCtrl.addActionListener(this);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.m_groupCtrl.getSelectedItem();
        this.m_brkgrpMgr.setCurrentGroup(string);
    }

    private class ComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointSwatchIcon m_icon = null;

        public ComboRenderer() {
            int n = ((Component)PaseToolbar.this.m_groupCtrl).getFontMetrics(PaseToolbar.this.m_groupCtrl.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
        }

        public int getIconWidth() {
            return this.m_icon.getIconWidth();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.m_icon.setColor(PaseToolbar.this.m_brkgrpMgr.getGroupColor((String)object));
            this.setIcon(this.m_icon);
            return this;
        }
    }

    protected class ComboBox
    extends JComboBox {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width += PaseToolbar.this.m_renderer.getIconWidth();
            return dimension;
        }
    }
}

