/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.PacketInflater;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UnixCommLink
extends CommLink {
    private boolean m_requireSignOn = true;
    private boolean m_unicodeHeaders = true;
    private boolean m_unicodeMsgs = false;
    private boolean m_unicodeStrings = false;

    public UnixCommLink(DebugWindow debugWindow, String string, int n, PacketInflater packetInflater) throws IOException {
        super(debugWindow, string, n, packetInflater);
    }

    public UnixCommLink(DebugWindow debugWindow, String string, String string2, int n, String string3, PacketInflater packetInflater) throws UnknownHostException {
        super(debugWindow, string, string2, n, string3, packetInflater);
    }

    public void setRequireSignOn(boolean bl) {
        this.m_requireSignOn = bl;
    }

    public void setUnicodeHeaders(boolean bl) {
        this.m_unicodeHeaders = bl;
    }

    public void setUnicodeMessages(boolean bl) {
        this.m_unicodeMsgs = bl;
    }

    public void setUnicodeStrings(boolean bl) {
        this.m_unicodeStrings = bl;
    }

    protected boolean requireSignon() {
        return this.m_requireSignOn;
    }

    public boolean connect(boolean bl) {
        this.setUnicodeStrings(this.m_unicodeHeaders);
        return super.connect(bl);
    }

    public boolean accept(boolean bl) {
        this.setUnicodeStrings(this.m_unicodeHeaders);
        return super.accept(bl);
    }

    public boolean relay(boolean bl) {
        boolean bl2 = super.relay(bl);
        this.setUnicodeStrings(this.m_unicodeMsgs);
        return bl2;
    }

    protected void readConnectHeader() throws IOException {
        if (this.m_unicodeHeaders) {
            super.readConnectHeader();
            return;
        }
        this.m_dataVersion = this.readDouble();
        String string = this.readString();
        if (this.m_system == null || this.m_system.length() == 0) {
            this.m_system = Util.upper(string);
        }
        this.m_ip = this.readString();
    }

    protected void writeConnectHeader() throws IOException {
        if (this.m_unicodeHeaders) {
            super.writeConnectHeader();
            return;
        }
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        String string2 = inetAddress.getHostAddress();
        this.writeDouble(CommLink.s_dataVersion);
        int n = this.writeSize(string) + this.writeSize(string2);
        this.writeInt(n);
        this.writeString(string);
        this.writeString(string2);
        this.flush();
    }

    public String readString() throws IOException {
        if (this.m_unicodeStrings) {
            return super.readString();
        }
        return this.readAsciiString();
    }

    public void writeString(String string) throws IOException {
        if (this.m_unicodeStrings) {
            super.writeString(string);
        } else {
            this.writeAsciiString(string);
        }
    }

    public int writeSize(String string) {
        if (this.m_unicodeStrings) {
            return super.writeSize(string);
        }
        return this.writeAsciiSize(string);
    }
}

