/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.manager;

import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import java.io.IOException;
import java.util.ArrayList;

public class UnixPgmManager
extends PgmManager {
    protected ArrayList m_unixMain;
    protected ArrayList m_unixPrivate;
    protected ArrayList m_unixShared;

    public UnixPgmManager(DebugContext debugContext) {
        super(debugContext);
    }

    public void init() {
        if (this.m_unixMain == null) {
            this.m_unixMain = new ArrayList();
        }
        if (this.m_unixPrivate == null) {
            this.m_unixPrivate = new ArrayList();
        }
        if (this.m_unixShared == null) {
            this.m_unixShared = new ArrayList();
        }
    }

    public void clear() {
        super.clear();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_unixMain = null;
        this.m_unixPrivate = null;
        this.m_unixShared = null;
    }

    protected void clearMaps() {
        super.clearMaps();
        this.m_unixMain.clear();
        this.m_unixPrivate.clear();
        this.m_unixShared.clear();
    }

    public String getCompletePath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (pgmDescriptor != null && moduleDescriptor != null) {
            ViewDescriptor viewDescriptor = (ViewDescriptor)this.m_viewIdToView.get(string);
            string2 = viewDescriptor.isAssembler() ? PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), null) : PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), moduleDescriptor.getModuleName());
        }
        return string2;
    }

    protected boolean ignorePgmType(int n) {
        switch (n) {
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    protected ArrayList pgmTypeToList(int n) {
        switch (n) {
            case 10: {
                return this.m_unixMain;
            }
            case 11: {
                return this.m_unixPrivate;
            }
            case 12: {
                return this.m_unixShared;
            }
        }
        return null;
    }

    public void fireProgramAddedEvent(PgmEvent pgmEvent) {
        int n;
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        boolean bl = this.m_viewIdToPgm.isEmpty();
        boolean bl2 = false;
        String string = null;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            n = pgmDescriptor.getPgmType();
            if (!this.ignorePgmType(n) && (n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n)) < 0) {
                ArrayList arrayList = this.pgmTypeToList(n);
                arrayList.add(n4 * -1 - 1, pgmDescriptor);
                int n5 = pgmDescriptor.getModuleCount();
                int n6 = 0;
                while (n6 < n5) {
                    ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(n6);
                    int n7 = moduleDescriptor.getViewCount();
                    sourceViewManager.rmvFromFilenameCache(moduleDescriptor.getModuleName());
                    int n8 = 0;
                    while (n8 < n7) {
                        ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(n8);
                        String string2 = viewDescriptor.getViewId();
                        if (n8 == 0 && bl && !bl2 && viewDescriptor.hasMain()) {
                            this.m_mainModule = moduleDescriptor;
                            string = string2;
                            bl2 = viewDescriptor.isAssembler() ? n6 == n5 - 1 : true;
                        }
                        this.m_viewIdToPgm.put(string2, pgmDescriptor);
                        this.m_viewIdToModule.put(string2, moduleDescriptor);
                        this.m_viewIdToView.put(string2, viewDescriptor);
                        ++n8;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int n9 = this.m_listeners.size();
        n = 0;
        while (n < n9) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(n);
            pgmListener.programAdded(pgmEvent);
            ++n;
        }
        if (bl && bl2) {
            sourceViewManager.autoRequestSourceView(string);
        }
    }

    public void fireProgramUpdatedEvent(PgmEvent pgmEvent) {
        int n;
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            n = pgmDescriptor.getPgmType();
            if (!this.ignorePgmType(n) && (n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n)) >= 0) {
                ArrayList arrayList = this.pgmTypeToList(n);
                PgmDescriptor pgmDescriptor2 = (PgmDescriptor)arrayList.get(n4);
                pgmEvent.setDescriptorAt(pgmDescriptor2.merge(pgmDescriptor), n3);
                int n5 = pgmDescriptor.getModuleCount();
                int n6 = 0;
                while (n6 < n5) {
                    ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(n6);
                    int n7 = moduleDescriptor.getViewCount();
                    sourceViewManager.rmvFromFilenameCache(moduleDescriptor.getModuleName());
                    int n8 = 0;
                    while (n8 < n7) {
                        ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(n8);
                        String string = viewDescriptor.getViewId();
                        this.m_viewIdToPgm.put(string, pgmDescriptor2);
                        this.m_viewIdToModule.put(string, moduleDescriptor);
                        this.m_viewIdToView.put(string, viewDescriptor);
                        ++n8;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int n9 = this.m_listeners.size();
        n = 0;
        while (n < n9) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(n);
            pgmListener.programUpdated(pgmEvent);
            ++n;
        }
    }

    public void fireProgramRemovedEvent(PgmEvent pgmEvent) {
        Object object;
        int n;
        int n2 = pgmEvent.getCount();
        int n3 = 0;
        while (n3 < n2) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            if (!this.ignorePgmType(pgmDescriptor.getPgmType()) && (n = this.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType())) >= 0) {
                Object object2;
                object = this.m_ctxt.getDesktop();
                BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
                SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                int n4 = pgmDescriptor.getModuleCount();
                int n5 = 0;
                while (n5 < n4) {
                    object2 = pgmDescriptor.getModuleAt(n5);
                    int n6 = ((ModuleDescriptor)object2).getViewCount();
                    sourceViewManager.rmvFromFilenameCache(((ModuleDescriptor)object2).getModuleName());
                    int n7 = 0;
                    while (n7 < n6) {
                        String string = ((ModuleDescriptor)object2).getViewId(n7);
                        breakpointManager.clearBreakpoints(string);
                        object.closeSource(string);
                        this.m_viewIdToPgm.remove(string);
                        this.m_viewIdToModule.remove(string);
                        this.m_viewIdToView.remove(string);
                        ++n7;
                    }
                    ++n5;
                }
                object2 = this.pgmTypeToList(pgmDescriptor.getPgmType());
                ((ArrayList)object2).remove(n);
            }
            ++n3;
        }
        int n8 = this.m_listeners.size();
        n = 0;
        while (n < n8) {
            object = (PgmListener)this.m_listeners.get(n);
            object.programRemoved(pgmEvent);
            ++n;
        }
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        return 0;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
    }
}

