/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.IleDebugContext;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;

public class UnixDebugOptionsPacket
extends UnixPacket
implements DebugConstants {
    private String m_srcPath;
    private int m_multiProc;
    private int m_options;
    private ISeriesMessage m_msgObj;

    public UnixDebugOptionsPacket() {
        super(3005);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_srcPath = commLink.readString();
        this.m_multiProc = commLink.readInt();
        this.m_options = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            this.m_ctxt.setMessage(MRI.get("DBG_DEBUG_OPTIONS_UPDATED"));
            if ((this.m_options & 0x400) != 0) {
                if (!this.m_ctxt.hasPartnerContext() && this.m_ctxt.isSupported(9, this.m_ctxt.getSystemVersion())) {
                    String[] stringArray = new String[]{"-s", this.m_ctxt.getSystem(), "-u", this.m_ctxt.getUser(), "-pid", this.m_ctxt.getJobId()};
                    IleDebugContext ileDebugContext = new IleDebugContext(this.m_ctxt.getDebugFrame(), stringArray);
                    this.m_ctxt.getDebugFrame().appendDebugContext(ileDebugContext, true);
                    ileDebugContext.init();
                }
            } else if (this.m_ctxt.hasPartnerContext() && this.m_ctxt.isMasterContext()) {
                this.m_ctxt.removePartnerContext();
            }
        }
    }
}

