/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.unix.packet.UnixPacket;
import com.ibm.iseries.unix.request.UnixExtendBrkRequest;
import java.io.IOException;
import java.text.MessageFormat;

public class UnixExtendBrkPacket
extends UnixPacket {
    private String m_viewId;

    public UnixExtendBrkPacket() {
        super(3010);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
    }

    public void run() {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        PgmDescriptor pgmDescriptor = pgmManager.getProgram(this.m_viewId);
        ModuleDescriptor moduleDescriptor = pgmManager.getModule(this.m_viewId);
        if (pgmDescriptor != null && moduleDescriptor != null) {
            Object[] objectArray = new Object[]{moduleDescriptor.getModuleName(), pgmDescriptor.getPgmPath()};
            String string = MessageFormat.format(MRI.get("DBG_DUP_MODULE_ENCOUNTERED_FMT"), objectArray);
            int n = Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
            UnixExtendBrkRequest unixExtendBrkRequest = new UnixExtendBrkRequest(this.m_viewId, n == 0);
            this.m_ctxt.sendRequest(unixExtendBrkRequest);
        } else {
            UnixExtendBrkRequest unixExtendBrkRequest = new UnixExtendBrkRequest(this.m_viewId, false);
            this.m_ctxt.sendRequest(unixExtendBrkRequest);
        }
        this.cleanUp();
    }
}

