/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.PickFromListDialog;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;
import java.text.MessageFormat;

public class UnixResolveSourcePacket
extends UnixPacket
implements DebugConstants {
    private String m_filename;
    private String[] m_viewIds;
    private ISeriesMessage m_msgObj;

    public UnixResolveSourcePacket() {
        super(3007);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_filename = null;
        this.m_viewIds = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_filename = commLink.readString();
        int n2 = commLink.readInt();
        this.m_viewIds = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_viewIds[n3] = commLink.readString();
            ++n3;
        }
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        if (this.m_msgObj == null) {
            if (this.m_viewIds.length > 1) {
                Object[] objectArray;
                PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
                String[] stringArray = new String[this.m_viewIds.length];
                int n = 0;
                while (n < this.m_viewIds.length) {
                    objectArray = pgmManager.getProgram(this.m_viewIds[n]);
                    stringArray[n] = objectArray != null ? objectArray.getPgmPath() : "****";
                    ++n;
                }
                objectArray = new Object[]{this.m_filename};
                String string = MessageFormat.format(MRI.get("DBG_SOURCE_FILE_CLARIFY_FMT"), objectArray);
                PickFromListDialog pickFromListDialog = new PickFromListDialog(this.m_ctxt.getJFrame(), MRI.get("DBG_GOTO_SOURCE"), string, MRI.get("DBG_OK"), null, stringArray, 0);
                pickFromListDialog.display(this.m_ctxt);
                if (!pickFromListDialog.wasCanceled()) {
                    int[] nArray = pickFromListDialog.getSelectedIndices();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        this.requestSourceView(this.m_viewIds[nArray[n2]]);
                        ++n2;
                    }
                }
            } else if (this.m_viewIds.length > 0) {
                this.requestSourceView(this.m_viewIds[0]);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }

    private void requestSourceView(String string) {
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
        DebugSource debugSource = debugDesktop.getSource(string);
        if (debugSource == null) {
            sourceViewManager.requestSourceView(string);
        } else {
            debugDesktop.activateSource(debugSource, -1);
            debugSource.viewRequestFocus();
        }
        if (this.m_viewIds.length == 1) {
            sourceViewManager.addToFilenameCache(this.m_filename, string);
        }
    }
}

