/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;

public class UnixStartDebugPacket
extends UnixPacket
implements DebugConstants {
    protected String m_pgmPath;
    protected String m_pgmParms;
    protected String m_pid;
    protected int m_multiProc;
    protected int m_addrSize;
    protected ISeriesMessage m_msgObj;

    public UnixStartDebugPacket() {
        super(3000);
    }

    public UnixStartDebugPacket(int n) {
        super(n);
    }

    public String getPgmPath() {
        return this.m_pgmPath;
    }

    public String getPgmParms() {
        return this.m_pgmParms;
    }

    public String getPid() {
        return this.m_pid;
    }

    public int getMultiProc() {
        return this.m_multiProc;
    }

    public int getAddrSizeInBits() {
        return this.m_addrSize;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_pgmPath = null;
        this.m_pgmParms = null;
        this.m_pid = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        this.m_pgmPath = commLink.readString();
        this.m_pgmParms = commLink.readString();
        this.m_pid = commLink.readString();
        this.m_multiProc = commLink.readInt();
        this.m_addrSize = commLink.readInt();
        if (this.m_pgmParms.length() > 0 && this.m_pgmParms.indexOf("''") >= 0) {
            StringBuffer stringBuffer = new StringBuffer(this.m_pgmParms);
            int n3 = 0;
            while (n3 < stringBuffer.length()) {
                if (stringBuffer.charAt(n3) == '\'' && n3 + 1 < stringBuffer.length() && stringBuffer.charAt(n3 + 1) == '\'') {
                    stringBuffer.deleteCharAt(n3);
                }
                ++n3;
            }
            this.m_pgmParms = stringBuffer.toString();
        }
        if ((n2 = commLink.readInt()) == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        this.m_ctxt.clearMessage();
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj, 2);
            this.m_ctxt.enableAction("chgsys", true);
            this.m_ctxt.enableAction("strdbg", true);
            this.m_ctxt.getMenubar().enablePgmMenu(true);
        } else {
            this.m_ctxt.setProgramInfo(this);
            this.m_ctxt.allowRunAction(true);
            this.m_ctxt.getActionGroup().setPgmRunning(false);
            this.m_ctxt.enableAction("chgsys", false);
            this.m_ctxt.enableAction("strdbg", false);
            this.m_ctxt.enableAction("enddbg", this.m_ctxt.isMasterContext());
            this.m_ctxt.enableAction("rstrdbg", true);
            this.m_ctxt.enableAction("kill", true);
            this.m_ctxt.enableAction("dbgopt", true);
            this.m_ctxt.enableAction("addmbrk", true);
            this.m_ctxt.enableAction("ngrp", true);
            this.m_ctxt.enableAction("oenv", true);
            this.m_ctxt.enableAction("senv", true);
            this.m_ctxt.enableAction("senvas", true);
            this.m_ctxt.getMenubar().enableEnvMenu(true);
            SettingsManager settingsManager = (SettingsManager)this.m_ctxt.getManager("settmgr");
            settingsManager.insertRecentPgm(new PgmDescriptor(this.m_pgmPath, this.m_pgmParms));
            this.m_ctxt.getMenubar().enablePgmMenu(false);
        }
        this.cleanUp();
    }
}

