/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UnixMethodsPanel
extends TabPanel
implements LAFListener,
DebugConstants,
MouseListener,
ActionListener,
ListSelectionListener,
ClipboardOwner {
    public static final String KEY = "methods";
    private static final String GIF = "/com/ibm/iseries/debug/dbg084.gif";
    private static final String GO = "go";
    private static final String TEXT = "txt";
    private JPanel m_panel = new JPanel(new BorderLayout());
    private JList m_list = new JList();
    private JScrollPane m_scrollPane = new JScrollPane(this.m_list);
    private ContextMenu m_contextMenu;
    private MethodTextField m_methodCtrl;
    private JButton m_go;

    public UnixMethodsPanel() {
        super(MRI.get("DBG_METHODS"), MRI.getIcon(0, GIF));
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(this);
        this.m_list.addMouseListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_METHOD_LABEL"));
        this.m_go = new JButton(MRI.get("DBG_GO"));
        this.m_go.setActionCommand(GO);
        this.m_go.addActionListener(this);
        this.m_go.setMargin(new Insets(0, 2, 0, 2));
        this.m_methodCtrl = new MethodTextField();
        this.m_methodCtrl.setActionCommand(TEXT);
        this.m_methodCtrl.addActionListener(this);
        this.m_list.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        this.m_methodCtrl.addFocusListener(this);
        this.m_go.addFocusListener(this);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.m_methodCtrl, "Center");
        jPanel.add((Component)jLabel, this.m_isLtoR ? "West" : "East");
        jPanel.add((Component)this.m_go, this.m_isLtoR ? "East" : "West");
        this.m_panel.add((Component)this.m_scrollPane, "Center");
        this.m_panel.add((Component)jPanel, "South");
        Util.setAccessible((Accessible)this.m_list, this.getTabText());
        Util.setAccessible((Accessible)this.m_methodCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_go, this.m_go.getText());
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(this.m_list);
        Util.setOrientation(this.m_methodCtrl, jLabel);
        Util.setOrientation(this.m_go);
    }

    private void lookAndFeelModifications() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("methodsContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void setMethods(String[] stringArray) {
        this.m_list.setListData(stringArray);
    }

    public String getSelectedMethod() {
        String string = this.m_methodCtrl.getText().trim();
        if (string.length() > 0) {
            this.m_methodCtrl.setText("");
        } else if (this.m_list.getSelectedIndex() >= 0) {
            string = (String)this.m_list.getSelectedValue();
        }
        return string;
    }

    private void clearActionContext() {
        if (this.m_ctxt != null) {
            this.m_ctxt.enableAction("gometh", false);
            this.m_ctxt.enableAction("copy", false);
        }
    }

    private void prepareActionContext() {
        if (!this.m_list.hasFocus() || this.m_list.isSelectionEmpty()) {
            this.clearActionContext();
            return;
        }
        if (this.m_ctxt != null) {
            this.m_ctxt.enableAction("gometh", true);
            this.m_ctxt.enableAction("copy", true);
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_list.removeMouseListener(this);
        this.m_list.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane = null;
        this.m_list = null;
        this.m_contextMenu = null;
        this.m_methodCtrl = null;
        this.m_go = null;
        super.cleanUp();
    }

    public void clear(boolean bl) {
        this.m_list.setListData(new String[0]);
    }

    public String getHelpId() {
        return "dbgmethods_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext();
        } else {
            this.clearActionContext();
        }
    }

    public boolean canDoCopy() {
        return !this.m_list.isSelectionEmpty();
    }

    public void copy() {
        String string = (String)this.m_list.getSelectedValue();
        if (string != null && string.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
        }
    }

    public boolean canDoFind() {
        return true;
    }

    public boolean find(String string) {
        String string2 = string.toUpperCase();
        ListModel listModel = this.m_list.getModel();
        int n = listModel.getSize();
        int n2 = this.m_list.getSelectedIndex();
        n2 = n2 == -1 ? 0 : ++n2;
        int n3 = n2;
        while (n3 < n) {
            String string3 = (String)listModel.getElementAt(n3);
            if (string3.toUpperCase().indexOf(string2) >= 0) {
                this.m_list.requestFocus();
                this.m_list.setSelectedIndex(n3);
                this.m_list.ensureIndexIsVisible(n3);
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(TEXT) || string.equals(GO)) {
            this.m_ctxt.getAction("gometh").run();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.prepareActionContext();
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            int n = this.m_list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                this.prepareActionContext();
                if (!this.m_list.isSelectedIndex(n)) {
                    this.m_list.setSelectedIndex(n);
                }
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent)) {
            this.prepareActionContext();
            int n = this.m_list.locationToIndex(mouseEvent.getPoint());
            if (mouseEvent.getClickCount() == 2 && n >= 0) {
                this.m_ctxt.getAction("gometh").run();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private class MethodTextField
    extends JTextField {
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
        }
    }
}

