/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class MessageLog {
    private static String m_logFileName;
    private static OutputStream m_outputStream;
    private static PrintWriter m_logTarget;
    private static boolean m_traceEnabled;

    public static void main(String[] stringArray) throws IOException {
        MessageLog.logError("This is a test error to the console");
        MessageLog.traceOut("Message to stdout");
        MessageLog.traceErr("Message to stderr");
        MessageLog.setLogFileName("framework.log");
        MessageLog.logError("This is a test error to framework.log");
        MessageLog.setLogStream(new FileOutputStream("user.log"));
        MessageLog.logError("This is a test error to user.log with throwable", new IllegalArgumentException("test exception"));
        MessageLog.setLogFileName(null);
        MessageLog.logError("This is a test error back to the console");
        MessageLog.setTraceEnabled(false);
        MessageLog.traceOut("Message to stdout should not be sent");
        MessageLog.traceErr("Message to stderr should not be sent");
        System.out.println("Test complete!");
    }

    private MessageLog() {
    }

    public static void setLogFileName(String string) throws IOException {
        if (m_logTarget != null) {
            m_logTarget.flush();
        }
        if (m_logFileName != null) {
            m_logTarget.close();
        }
        if ((m_logFileName = string) != null) {
            File file = new File(m_logFileName);
            m_outputStream = new FileOutputStream(m_logFileName, file.exists());
            m_logTarget = new PrintWriter(m_outputStream, true);
        } else {
            m_outputStream = System.err;
            m_logTarget = new PrintWriter(System.err, true);
        }
    }

    public static String getLogFileName() {
        return m_logFileName;
    }

    public static void setLogStream(OutputStream outputStream) {
        m_logTarget.flush();
        if (m_logFileName != null) {
            m_logTarget.close();
        }
        m_logFileName = null;
        if (outputStream != null) {
            m_outputStream = outputStream;
            m_logTarget = new PrintWriter(m_outputStream, true);
        } else {
            m_outputStream = System.err;
            m_logTarget = new PrintWriter(System.err, true);
        }
    }

    public static OutputStream getLogStream() {
        return m_outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logError(Object object) {
        PrintWriter printWriter = m_logTarget;
        synchronized (printWriter) {
            MessageLog.logTimeStamp();
            m_logTarget.println(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logError(Object object, Throwable throwable) {
        PrintWriter printWriter = m_logTarget;
        synchronized (printWriter) {
            MessageLog.logTimeStamp();
            m_logTarget.println(object);
            if (throwable != null) {
                MessageLog.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable) {
        PrintWriter printWriter = m_logTarget;
        synchronized (printWriter) {
            MessageLog.logTimeStamp();
            m_logTarget.println(SystemResourceFinder.format("stackTrace"));
            throwable.printStackTrace(m_logTarget);
        }
    }

    public static void setTraceEnabled(boolean bl) {
        m_traceEnabled = bl;
    }

    public static boolean isTraceEnabled() {
        return m_traceEnabled;
    }

    public static void traceOut(Object object) {
        if (m_traceEnabled) {
            System.out.println(object);
        }
    }

    public static void traceErr(Object object) {
        if (m_traceEnabled) {
            System.err.println(object);
        }
    }

    private static void logTimeStamp() {
        if (!m_outputStream.equals(System.err)) {
            m_logTarget.print(new Date().toString());
            m_logTarget.print("  ");
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    static {
        m_traceEnabled = true;
        try {
            MessageLog.setLogFileName(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

