/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.AbortException;
import com.ibm.as400.ui.framework.FrameworkDefaults;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PanelDefinitionsDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.WizardDescriptor;
import com.ibm.as400.ui.framework.WizardPageDescriptor;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class XMLWizardDefinition
implements Serializable,
DocumentHandler {
    private transient String m_baseName;
    private transient Locale m_locale;
    private transient String m_wizardName;
    private transient ResourceBundle m_bundle;
    private transient String m_documentName;
    private transient String m_sxml = null;
    private static transient boolean m_bElementTrace = false;
    private transient PDMLSpecificationException m_pdmlException = null;
    private PanelDefinitionsDescriptor m_wizardDefinitions = new PanelDefinitionsDescriptor();
    private WizardDescriptor m_wizardDescriptor = new WizardDescriptor();
    private Vector m_wizardPageDescriptors = new Vector();
    static final long serialVersionUID = 2344572645989030965L;
    private String m_chars = "";
    private Stack m_stack = null;
    private boolean found = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        m_bElementTrace = true;
        if (stringArray.length == 2) {
            XMLWizardDefinition xMLWizardDefinition;
            try {
                xMLWizardDefinition = new XMLWizardDefinition(stringArray[0], null, stringArray[1]);
            }
            catch (ParseException parseException) {
                parseException.reportErrors();
                return;
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                pDMLSpecificationException.reportErrors();
                return;
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            xMLWizardDefinition.dump();
        } else {
            System.out.println("Arguments are: <resource bundle name> <panel name>");
        }
    }

    public XMLWizardDefinition(String string, Locale locale, String string2) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale;
        this.m_wizardName = string2;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = FrameworkDefaults.m_resourceMode == 1 ? (locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string)) : SystemResourceFinder.getUncachedBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLWizardDefinition(String string, Locale locale) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLWizardDefinition(String string, ResourceBundle resourceBundle, String string2, String string3, PanelDefinitionsDescriptor panelDefinitionsDescriptor) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_wizardName = string2;
        this.m_bundle = resourceBundle;
        this.m_documentName = this.addLocale(this.m_baseName, panelDefinitionsDescriptor.m_localeString) + ".pdml";
        this.m_sxml = string3;
        this.m_wizardDefinitions = panelDefinitionsDescriptor;
        this.parseXML(true);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLWizardDefinition(String string) {
        this.m_wizardName = string;
        this.m_wizardDescriptor.m_name = string;
    }

    public PanelDefinitionsDescriptor getWizardDefinitions() {
        return this.m_wizardDefinitions;
    }

    public WizardDescriptor getWizard() {
        return this.m_wizardDescriptor;
    }

    public Vector getWizardPages() {
        return this.m_wizardPageDescriptors;
    }

    public String toString() {
        return this.getClass().getName() + "[baseName=" + this.m_baseName + ",wizardName=" + this.m_wizardName + "]";
    }

    public void dump() {
        System.out.println(this.m_wizardDefinitions);
        System.out.println(this.m_wizardDescriptor);
        Enumeration enumeration = this.m_wizardPageDescriptors.elements();
        while (enumeration.hasMoreElements()) {
            WizardPageDescriptor wizardPageDescriptor = (WizardPageDescriptor)enumeration.nextElement();
            System.out.println(wizardPageDescriptor);
        }
    }

    private String addLocale(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    private void parseXML(boolean bl) throws FileNotFoundException, IOException, ParseException {
        InputStream inputStream = SystemResourceFinder.getPDMLHeader();
        InputStream inputStream2 = null;
        inputStream2 = !bl ? SystemResourceFinder.getPDMLDocument(this.m_baseName, this.m_locale) : new BufferedInputStream(new FileInputStream(this.m_sxml));
        this.m_documentName = this.m_baseName + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        XMLSAXErrorHandler xMLSAXErrorHandler = new XMLSAXErrorHandler(this.m_documentName, SystemResourceFinder.getHeaderLineCount());
        Object object = XMLPanelDefinition.getParser(this, xMLSAXErrorHandler);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        InputSource inputSource = new InputSource(sequenceInputStream);
        XMLPanelDefinition.introspectMethod(object, "parse", new Object[]{inputSource}, new Class[]{inputSource.getClass()}, this.m_baseName);
        sequenceInputStream.close();
        ParseException parseException = xMLSAXErrorHandler.getException();
        if (parseException != null) {
            throw parseException;
        }
    }

    private void processError(String string) {
        if (this.m_pdmlException == null) {
            Object[] objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        this.m_pdmlException.addMessage(string);
    }

    private void processError(Throwable throwable, String string) {
        Object[] objectArray;
        if (this.m_pdmlException == null) {
            objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        if (throwable instanceof NumberFormatException) {
            objectArray = new Object[]{throwable.getMessage(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("valueNotNumeric", objectArray));
        } else {
            objectArray = new Object[]{throwable.toString(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("unknownValidationError", objectArray));
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        if (this.m_wizardDescriptor.m_name == null) {
            if (this.m_locale == null) {
                Object[] objectArray = new Object[]{this.m_wizardName, this.m_baseName};
                throw new MissingResourceException(SystemResourceFinder.format("wizardNotFound", objectArray), this.m_baseName, this.m_wizardName);
            }
            Object[] objectArray = new Object[]{this.m_wizardName, new String(this.m_baseName + "_" + this.m_locale)};
            throw new MissingResourceException(SystemResourceFinder.format("wizardNotFound", objectArray), this.m_baseName + "_" + this.m_locale, this.m_wizardName);
        }
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this.found) {
            this.debug("<" + string + ">");
        }
        if (!this.found) {
            if (string.equalsIgnoreCase("PDML")) {
                this.m_wizardDefinitions.m_baseName = this.m_baseName;
                this.debug("Base name: " + this.m_wizardDefinitions.m_baseName);
                this.m_wizardDefinitions.m_locale = this.m_locale;
                this.m_wizardDefinitions.m_localeString = SystemResourceFinder.getLastDocumentLocale();
                this.debug("Locale string: " + this.m_wizardDefinitions.m_localeString);
                int n = 0;
                while (n < attributeList.getLength()) {
                    block35: {
                        String string2 = attributeList.getName(n);
                        String string3 = attributeList.getValue(n).trim();
                        if (string2.equalsIgnoreCase("VERSION")) {
                            this.m_wizardDefinitions.m_version = string3;
                            this.debug("Version: " + this.m_wizardDefinitions.m_version);
                        } else if (string2.equalsIgnoreCase("SOURCE")) {
                            this.m_wizardDefinitions.m_source = string3.toUpperCase();
                            this.debug("Source: " + this.m_wizardDefinitions.m_source);
                        } else if (string2.equalsIgnoreCase("BASESCREENSIZE")) {
                            Object[] objectArray;
                            String string4 = string3;
                            int n2 = string4.indexOf(120);
                            if (n2 == -1) {
                                this.debug("Base Screen Size '" + string4 + "' invalid");
                                objectArray = new Object[]{string4, string2.toString()};
                                this.processError(SystemResourceFinder.format("baseScreenSizeNotValid", objectArray));
                            } else {
                                objectArray = string4.substring(0, n2).trim();
                                String string5 = string4.substring(n2 + 1).trim();
                                try {
                                    int n3 = Integer.parseInt((String)objectArray);
                                    int n4 = Integer.parseInt(string5);
                                    this.m_wizardDefinitions.m_baseScreenSize.setSize(n3, n4);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.debug("Base Screen Size '" + string4 + "' invalid");
                                    this.processError(numberFormatException, string2);
                                    break block35;
                                }
                                this.debug("Storing base screen size: " + string4);
                            }
                        }
                    }
                    ++n;
                }
            } else if (string.equalsIgnoreCase("WIZARD")) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    String string6 = attributeList.getName(n);
                    String string7 = attributeList.getValue(n).trim();
                    if (string6.equalsIgnoreCase("NAME") && string7 != null && string7.equals(this.m_wizardName)) {
                        this.found = true;
                        this.m_wizardDescriptor.m_name = string7;
                        this.m_stack.push(this.m_wizardDescriptor);
                    }
                    ++n;
                }
            }
        } else if (string.equalsIgnoreCase("STEP")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("ICON")) {
            int n = 0;
            while (n < attributeList.getLength()) {
                Object[] objectArray;
                String string8 = attributeList.getName(n);
                String string9 = attributeList.getValue(n).trim();
                if (string8.equalsIgnoreCase("POSITION")) {
                    objectArray = new Object[]{this.m_wizardDescriptor.toString()};
                    this.processError(SystemResourceFinder.format("positionOnlyValidForButton", objectArray));
                } else if (string8.equalsIgnoreCase("VPOSITION")) {
                    objectArray = new Object[]{this.m_wizardDescriptor.toString()};
                    this.processError(SystemResourceFinder.format("vpositionOnlyValidForButton", objectArray));
                }
                ++n;
            }
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("PAGE")) {
            WizardPageDescriptor wizardPageDescriptor = new WizardPageDescriptor();
            int n = 0;
            while (n < attributeList.getLength()) {
                String string10 = attributeList.getName(n);
                String string11 = attributeList.getValue(n).trim();
                if (string10.equalsIgnoreCase("NAME")) {
                    wizardPageDescriptor.m_pageName = string11;
                } else if (string10.equalsIgnoreCase("RESOURCE")) {
                    wizardPageDescriptor.m_baseName = string11;
                } else if (string10.equalsIgnoreCase("STEPINDEX")) {
                    try {
                        wizardPageDescriptor.m_stepIndex = Integer.parseInt(string11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.debug("Step Index '" + string11 + "' invalid");
                        this.processError(numberFormatException, string10);
                    }
                }
                ++n;
            }
            this.debug("Storing resource name: " + wizardPageDescriptor.m_baseName);
            this.debug("Storing page name: " + wizardPageDescriptor.m_pageName);
            this.debug("Storing step index: " + wizardPageDescriptor.m_stepIndex);
            this.m_wizardPageDescriptors.addElement(wizardPageDescriptor);
            this.m_stack.push(wizardPageDescriptor);
        }
    }

    public void endElement(String string) {
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (this.found) {
            this.m_stack.pop();
            if (this.m_stack.empty()) {
                this.found = false;
                throw new AbortException();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.found) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            this.debug("STRING expected on the stack");
            return;
        }
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        String string = this.m_chars;
        String string2 = (String)this.m_stack.pop();
        if (string2.equalsIgnoreCase("ICON")) {
            this.m_wizardDescriptor.m_icon = string;
            try {
                this.m_wizardDescriptor.m_icon = this.m_bundle.getString(this.m_wizardDescriptor.m_icon);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.debug("Storing property sheet icon: " + this.m_wizardDescriptor.m_icon);
        } else if (string2.equalsIgnoreCase("STEP")) {
            if (this.m_wizardDescriptor.m_steps == null) {
                this.m_wizardDescriptor.m_steps = new Vector();
            }
            if (this.m_wizardDescriptor.m_stepBundle == null) {
                this.m_wizardDescriptor.m_stepBundle = new Vector();
            }
            String string3 = string;
            this.m_wizardDescriptor.m_stepBundle.addElement(string3);
            try {
                string3 = this.m_bundle.getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.m_wizardDescriptor.m_steps.addElement(string3);
            this.debug("Storing wizard step: " + string3);
        }
        this.m_stack.push(string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    private void debug(String string) {
        if (m_bElementTrace) {
            System.out.println("XMLWizardDefinition: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    public String getWizardName() {
        return this.m_wizardName;
    }
}

