/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PaneDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLSplitPaneDefinition;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.DeckPaneManager;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.JavaComponentDescriptor;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.TabbedPaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SplitPaneManager
implements PaneManager {
    private Locale m_locale;
    private XMLSplitPaneDefinition m_spd;
    private DataBean[] m_dataBeans;
    private JSplitPane m_splitPane;
    private Container m_container;
    private Vector m_panes;
    private Vector m_panels = new Vector();
    Hashtable m_panelTable = new Hashtable();
    private boolean m_dataLoaded = false;
    private PaneManager m_aggregateManager;
    static boolean m_descriptorTrace = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("paneManagerArguments");
        if (stringArray.length == 2) {
            JFrame jFrame = new JFrame("SplitPaneManager Test");
            jFrame.setResizable(false);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            SplitPaneManager splitPaneManager = null;
            try {
                splitPaneManager = new SplitPaneManager(stringArray[0], stringArray[1], null, jFrame.getContentPane());
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
            splitPaneManager.loadData();
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        } else if (stringArray.length == 3) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.err.println(string);
                System.exit(0);
            }
            try {
                new SplitPaneManager(stringArray[1], null, stringArray[2]);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                JFrame jFrame = new JFrame("SplitPaneManager Test");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                SplitPaneManager splitPaneManager = null;
                try {
                    splitPaneManager = new SplitPaneManager(stringArray[2], locale, stringArray[3], null, jFrame.getContentPane());
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                splitPaneManager.loadData();
                jFrame.pack();
                ((Component)jFrame).setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new SplitPaneManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public SplitPaneManager(String string, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container);
    }

    public SplitPaneManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.m_spd = this.constructSplitPaneDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public SplitPaneManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullSplitPaneNameArgument"));
        }
        try {
            this.m_spd = new XMLSplitPaneDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    SplitPaneManager(XMLSplitPaneDefinition xMLSplitPaneDefinition, DataBean[] dataBeanArray, Container container, PaneManager paneManager) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.debug("split pane definition: " + xMLSplitPaneDefinition + "  locale: " + xMLSplitPaneDefinition.getSplitPaneDefinitions().m_locale);
        this.setAggregateManager(paneManager);
        this.m_spd = xMLSplitPaneDefinition;
        this.m_locale = xMLSplitPaneDefinition.getSplitPaneDefinitions().m_locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public void serialize() throws IOException {
        this.saveSplitPaneDefinition(this.m_spd.getSplitPane().m_name + this.m_spd.getSplitPaneDefinitions().m_localeString + ".pdml.ser");
    }

    public Dimension getPreferredSize() {
        if (this.m_container != null) {
            return this.m_container.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public String getTitle() {
        return this.m_spd.getSplitPane().m_title;
    }

    public void loadData() {
        if (!this.m_dataLoaded && this.m_container != null) {
            int n = 0;
            while (n < this.m_panels.size()) {
                PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
                paneManager.loadData();
                ++n;
            }
        }
        this.m_dataLoaded = true;
    }

    public void activatePanel() {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.activatePanel();
            ++n;
        }
    }

    public void showPane(String string) {
    }

    public Component getComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponent(string3) : null;
    }

    public JavaComponentDescriptor getComponentDescriptor(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponentDescriptor(string3) : null;
    }

    public PaneManager getDelegateManager(String string) {
        return (PaneManager)this.m_panelTable.get(string);
    }

    public void setAggregateManager(PaneManager paneManager) {
        this.m_aggregateManager = paneManager;
    }

    public PaneManager getAggregateManager() {
        return this.m_aggregateManager;
    }

    public PaneManager getRootManager() {
        PaneManager paneManager = this.m_aggregateManager;
        PaneManager paneManager2 = null;
        while (paneManager != null) {
            paneManager2 = paneManager;
            paneManager = paneManager.getAggregateManager();
        }
        return paneManager2;
    }

    public void applyChanges() throws IllegalUserDataException {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.applyChanges();
            ++n;
        }
    }

    public void prepareToCommit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.prepareToCommit(vector);
            ++n;
        }
    }

    public void commit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.commit(vector);
            ++n;
        }
    }

    public void setFormatter(String string, DataFormatter dataFormatter, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullFormatterArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            Object[] objectArray = new Object[]{string2, new String(this.m_spd.getSplitPaneDefinitions().m_baseName + this.m_spd.getSplitPaneDefinitions().m_localeString)};
            throw new IllegalArgumentException(SystemResourceFinder.format("panelNotFound", objectArray));
        }
        panelManager.setFormatter(string3, dataFormatter, bl);
    }

    public DataFormatter getFormatter(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            return null;
        }
        return panelManager.getFormatter(string3);
    }

    public void setHelpPath(String string) {
        Enumeration enumeration = this.m_panelTable.elements();
        while (enumeration.hasMoreElements()) {
            PaneManager paneManager = (PaneManager)enumeration.nextElement();
            paneManager.setHelpPath(string);
        }
    }

    private XMLSplitPaneDefinition constructSplitPaneDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLSplitPaneDefinition xMLSplitPaneDefinition;
        block17: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullSplitPaneNameArgument"));
            }
            xMLSplitPaneDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLSplitPaneDefinition = this.loadSplitPaneDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedSplitPaneNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block17;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLSplitPaneDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("splitPaneLoaded", object));
            if (m_descriptorTrace) {
                xMLSplitPaneDefinition.dump();
            }
            return xMLSplitPaneDefinition;
        }
        try {
            xMLSplitPaneDefinition = new XMLSplitPaneDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLSplitPaneDefinition.getSplitPaneDefinitions().m_baseName + xMLSplitPaneDefinition.getSplitPaneDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("splitPaneParsed", object));
        if (m_descriptorTrace) {
            xMLSplitPaneDefinition.dump();
        }
        return xMLSplitPaneDefinition;
    }

    private XMLSplitPaneDefinition loadSplitPaneDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLSplitPaneDefinition xMLSplitPaneDefinition = (XMLSplitPaneDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLSplitPaneDefinition;
    }

    private void saveSplitPaneDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("splitPaneSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_spd);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() throws DisplayManagerException {
        LookAndFeelManager.setLookAndFeel();
        this.m_splitPane = new JSplitPane();
        int n = this.m_spd.getSplitPane().m_orientation.equals("HORIZONTAL") ? 1 : 0;
        this.m_splitPane.setOrientation(n);
        if (UIFramework.isDynamicResizingEnabled()) {
            this.m_container.setLayout(new BorderLayout());
            this.m_container.add((Component)this.m_splitPane, "Center");
        } else {
            this.m_container.setLayout(new FlowLayout(1, 0, 0));
            this.m_container.add(this.m_splitPane);
        }
        this.m_panes = this.m_spd.getPanes();
        if (this.m_panes.isEmpty()) {
            return;
        }
        int n2 = 0;
        while (n2 < 2) {
            block17: {
                JPanel jPanel;
                block16: {
                    PaneManager paneManager;
                    PaneDescriptor paneDescriptor;
                    block15: {
                        paneDescriptor = (PaneDescriptor)this.m_panes.elementAt(n2);
                        this.debug("Processing " + paneDescriptor.m_paneType);
                        jPanel = new JPanel(false);
                        if (!paneDescriptor.m_paneType.equals("PANEL")) break block15;
                        paneManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, (Container)jPanel) : new PanelManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel);
                        ((PanelManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                        ((PanelManager)paneManager).activatePanel();
                        if (!((PanelManager)paneManager).isContainerScrollable()) break block16;
                        JScrollPane jScrollPane = new JScrollPane(jPanel);
                        jScrollPane.setBorder(null);
                        if (n2 == 0) {
                            this.m_splitPane.setLeftComponent(jScrollPane);
                        } else {
                            this.m_splitPane.setRightComponent(jScrollPane);
                        }
                        break block17;
                    }
                    if (paneDescriptor.m_paneType.equals("SPLIT")) {
                        paneManager = new SplitPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel);
                        ((SplitPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    } else if (paneDescriptor.m_paneType.equals("DECK")) {
                        paneManager = new DeckPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel);
                        ((DeckPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    } else if (paneDescriptor.m_paneType.equals("TAB")) {
                        paneManager = new TabbedPaneManager(paneDescriptor.m_baseName, this.m_locale, paneDescriptor.m_paneName, this.m_dataBeans, jPanel);
                        ((TabbedPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(paneDescriptor.m_paneName, paneManager);
                    }
                }
                if (n2 == 0) {
                    this.m_splitPane.setLeftComponent(jPanel);
                } else {
                    this.m_splitPane.setRightComponent(jPanel);
                }
            }
            ++n2;
        }
        if (n == 1) {
            this.m_splitPane.setDividerLocation(this.m_splitPane.getLeftComponent().getPreferredSize().width + this.m_splitPane.getDividerSize() / 2);
        } else {
            this.m_splitPane.setDividerLocation(this.m_splitPane.getTopComponent().getPreferredSize().height + this.m_splitPane.getDividerSize() / 2);
        }
    }

    private void debug(String string) {
        if (m_descriptorTrace) {
            System.out.println("SplitPaneManager: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

