/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PaneDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLTabbedPaneDefinition;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.DeckPaneManager;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.JavaComponentDescriptor;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.SplitPaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class TabbedPaneManager
implements PaneManager {
    private Locale m_locale;
    private XMLTabbedPaneDefinition m_tpd;
    private DataBean[] m_dataBeans;
    private JTabbedPane m_tabbedPane;
    private Container m_container;
    private Vector m_panes;
    private Vector m_panels = new Vector();
    Hashtable m_panelTable = new Hashtable();
    private PaneManager m_activePanel;
    private boolean m_dataLoaded = false;
    private PaneManager m_aggregateManager;
    static boolean m_descriptorTrace = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("paneManagerArguments");
        if (stringArray.length == 2) {
            JFrame jFrame = new JFrame("TabbedPaneManager Test");
            jFrame.setResizable(false);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            TabbedPaneManager tabbedPaneManager = null;
            try {
                tabbedPaneManager = new TabbedPaneManager(stringArray[0], stringArray[1], null, jFrame.getContentPane());
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
            tabbedPaneManager.loadData();
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        } else if (stringArray.length == 3) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.err.println(string);
                System.exit(0);
            }
            try {
                new TabbedPaneManager(stringArray[1], null, stringArray[2]);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                JFrame jFrame = new JFrame("TabbedPaneManager Test");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                TabbedPaneManager tabbedPaneManager = null;
                try {
                    tabbedPaneManager = new TabbedPaneManager(stringArray[0], locale, stringArray[1], null, jFrame.getContentPane());
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                tabbedPaneManager.loadData();
                jFrame.pack();
                ((Component)jFrame).setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new TabbedPaneManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public TabbedPaneManager(String string, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container);
    }

    public TabbedPaneManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.m_tpd = this.constructTabbedPaneDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public TabbedPaneManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullTabbedPaneNameArgument"));
        }
        try {
            this.m_tpd = new XMLTabbedPaneDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    TabbedPaneManager(XMLTabbedPaneDefinition xMLTabbedPaneDefinition, DataBean[] dataBeanArray, Container container, PaneManager paneManager) throws DisplayManagerException {
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.debug("Tabbed pane definition: " + xMLTabbedPaneDefinition + "  locale: " + xMLTabbedPaneDefinition.getTabbedPaneDefinitions().m_locale);
        this.setAggregateManager(paneManager);
        this.m_tpd = xMLTabbedPaneDefinition;
        this.m_locale = xMLTabbedPaneDefinition.getTabbedPaneDefinitions().m_locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.constructUI();
    }

    public void serialize() throws IOException {
        this.saveTabbedPaneDefinition(this.m_tpd.getTabbedPane().m_name + this.m_tpd.getTabbedPaneDefinitions().m_localeString + ".pdml.ser");
    }

    public Dimension getPreferredSize() {
        if (this.m_container != null) {
            return this.m_container.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public JTabbedPane getTabbedPane() {
        return this.m_tabbedPane;
    }

    public String getTitle() {
        return this.m_tpd.getTabbedPane().m_title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        if (!this.m_dataLoaded && this.m_container != null) {
            TabbedPaneManager tabbedPaneManager = this;
            synchronized (tabbedPaneManager) {
                int n = 0;
                while (n < this.m_panels.size()) {
                    PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
                    paneManager.loadData();
                    ++n;
                }
                this.m_dataLoaded = true;
            }
        }
    }

    public void activatePanel() {
        if (this.m_activePanel != null) {
            this.m_activePanel.activatePanel();
        }
    }

    public void showPane(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_panes.size()) {
            PaneDescriptor paneDescriptor = (PaneDescriptor)this.m_panes.elementAt(n2);
            if (paneDescriptor.m_paneName.equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        this.m_tabbedPane.setSelectedIndex(n);
        this.m_activePanel = (PaneManager)this.m_panels.elementAt(n);
        this.m_activePanel.activatePanel();
    }

    public Component getComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponent(string3) : null;
    }

    public JavaComponentDescriptor getComponentDescriptor(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponentDescriptor(string3) : null;
    }

    public PaneManager getDelegateManager(String string) {
        return (PaneManager)this.m_panelTable.get(string);
    }

    public void setAggregateManager(PaneManager paneManager) {
        this.m_aggregateManager = paneManager;
    }

    public PaneManager getAggregateManager() {
        return this.m_aggregateManager;
    }

    public PaneManager getRootManager() {
        PaneManager paneManager = this.m_aggregateManager;
        PaneManager paneManager2 = null;
        while (paneManager != null) {
            paneManager2 = paneManager;
            paneManager = paneManager.getAggregateManager();
        }
        return paneManager2;
    }

    public void applyChanges() throws IllegalUserDataException {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            try {
                paneManager.applyChanges();
            }
            catch (IllegalUserDataException illegalUserDataException) {
                this.m_tabbedPane.setSelectedIndex(n);
                throw (IllegalUserDataException)illegalUserDataException.fillInStackTrace();
            }
            ++n;
        }
    }

    public void prepareToCommit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.prepareToCommit(vector);
            ++n;
        }
    }

    public void commit(Vector vector) {
        int n = 0;
        while (n < this.m_panels.size()) {
            PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
            paneManager.commit(vector);
            ++n;
        }
    }

    public void setFormatter(String string, DataFormatter dataFormatter, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullFormatterArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            Object[] objectArray = new Object[]{string2, new String(this.m_tpd.getTabbedPaneDefinitions().m_baseName + this.m_tpd.getTabbedPaneDefinitions().m_localeString)};
            throw new IllegalArgumentException(SystemResourceFinder.format("panelNotFound", objectArray));
        }
        panelManager.setFormatter(string3, dataFormatter, bl);
    }

    public DataFormatter getFormatter(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            return null;
        }
        return panelManager.getFormatter(string3);
    }

    public void setHelpPath(String string) {
        Enumeration enumeration = this.m_panelTable.elements();
        while (enumeration.hasMoreElements()) {
            PaneManager paneManager = (PaneManager)enumeration.nextElement();
            paneManager.setHelpPath(string);
        }
    }

    public void addPane(PanelManager panelManager, int n) {
        panelManager.setAggregateManager(this);
        panelManager.setFocusPolicy(false);
        this.m_panels.insertElementAt(panelManager, n);
        this.m_panelTable.put(panelManager.getName(), panelManager);
        PaneDescriptor paneDescriptor = new PaneDescriptor();
        paneDescriptor.m_paneName = panelManager.getName();
        paneDescriptor.m_paneType = "PANEL";
        this.m_panes.insertElementAt(paneDescriptor, n);
        this.m_tabbedPane.insertTab(panelManager.getTitle(), null, panelManager.getContainer(), null, n);
    }

    public void removePane(String string) {
        PaneManager paneManager = (PaneManager)this.m_panelTable.get(string);
        int n = this.m_panels.indexOf(paneManager);
        if (n != -1) {
            this.removePane(n);
        }
    }

    public void removePane(int n) {
        this.m_tabbedPane.removeTabAt(n);
        PaneManager paneManager = (PaneManager)this.m_panels.elementAt(n);
        this.m_panels.removeElement(paneManager);
        this.m_panelTable.remove(((PaneDescriptor)this.m_panes.elementAt((int)n)).m_paneName);
        this.m_panes.removeElementAt(n);
        paneManager.setAggregateManager(null);
    }

    private XMLTabbedPaneDefinition constructTabbedPaneDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLTabbedPaneDefinition xMLTabbedPaneDefinition;
        block17: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullTabbedPaneNameArgument"));
            }
            xMLTabbedPaneDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLTabbedPaneDefinition = this.loadTabbedPaneDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedTabbedPaneNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block17;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLTabbedPaneDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("tabbedPaneLoaded", object));
            if (m_descriptorTrace) {
                xMLTabbedPaneDefinition.dump();
            }
            return xMLTabbedPaneDefinition;
        }
        try {
            xMLTabbedPaneDefinition = new XMLTabbedPaneDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLTabbedPaneDefinition.getTabbedPaneDefinitions().m_baseName + xMLTabbedPaneDefinition.getTabbedPaneDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("tabbedPaneParsed", object));
        if (m_descriptorTrace) {
            xMLTabbedPaneDefinition.dump();
        }
        return xMLTabbedPaneDefinition;
    }

    private XMLTabbedPaneDefinition loadTabbedPaneDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLTabbedPaneDefinition xMLTabbedPaneDefinition = (XMLTabbedPaneDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLTabbedPaneDefinition;
    }

    private void saveTabbedPaneDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("tabbedPaneSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_tpd);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() throws DisplayManagerException {
        Serializable serializable;
        int n;
        LookAndFeelManager.setLookAndFeel();
        String string = this.m_tpd.getTabbedPane().m_placement;
        int n2 = 1;
        if (string.equals("TOP")) {
            n2 = 1;
        } else if (string.equals("BOTTOM")) {
            n2 = 3;
        } else if (string.equals("LEFT")) {
            n2 = 2;
        } else if (string.equals("RIGHT")) {
            n2 = 4;
        }
        this.m_tabbedPane = new JTabbedPane(n2);
        if (!this.m_tpd.getTabbedPaneDefinitions().m_source.equals("WINDOWS")) {
            n = PanelManager.computeFontSize(this.m_container);
            serializable = this.m_container.getFont();
            this.m_tabbedPane.setFont(new Font(serializable.getName(), serializable.getStyle(), n));
        }
        if (UIFramework.isDynamicResizingEnabled()) {
            this.m_container.setLayout(new BorderLayout());
            this.m_container.add((Component)this.m_tabbedPane, "Center");
        } else {
            this.m_container.setLayout(new FlowLayout(1, 0, 0));
            this.m_container.add(this.m_tabbedPane);
        }
        this.m_panes = this.m_tpd.getPanes();
        if (this.m_panes.isEmpty()) {
            return;
        }
        n = 0;
        while (n < this.m_panes.size()) {
            block19: {
                String string2;
                JPanel jPanel;
                block18: {
                    PaneManager paneManager;
                    block17: {
                        serializable = (PaneDescriptor)this.m_panes.elementAt(n);
                        jPanel = new JPanel(false);
                        string2 = "";
                        if (!((PaneDescriptor)serializable).m_paneType.equals("PANEL")) break block17;
                        paneManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(((PaneDescriptor)serializable).m_baseName, this.m_locale, ((PaneDescriptor)serializable).m_paneName, this.m_dataBeans, (Container)jPanel) : new PanelManager(((PaneDescriptor)serializable).m_baseName, this.m_locale, ((PaneDescriptor)serializable).m_paneName, this.m_dataBeans, jPanel);
                        ((PanelManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(((PaneDescriptor)serializable).m_paneName, paneManager);
                        string2 = ((PanelManager)paneManager).getTitle();
                        ((PanelManager)paneManager).activatePanel();
                        if (!((PanelManager)paneManager).isContainerScrollable()) break block18;
                        JScrollPane jScrollPane = new JScrollPane(jPanel);
                        jScrollPane.setBorder(null);
                        this.m_tabbedPane.addTab(string2, jScrollPane);
                        break block19;
                    }
                    if (((PaneDescriptor)serializable).m_paneType.equals("SPLIT")) {
                        paneManager = new SplitPaneManager(((PaneDescriptor)serializable).m_baseName, this.m_locale, ((PaneDescriptor)serializable).m_paneName, this.m_dataBeans, jPanel);
                        ((SplitPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(((PaneDescriptor)serializable).m_paneName, paneManager);
                        string2 = ((SplitPaneManager)paneManager).getTitle();
                    } else if (((PaneDescriptor)serializable).m_paneType.equals("DECK")) {
                        paneManager = new DeckPaneManager(((PaneDescriptor)serializable).m_baseName, this.m_locale, ((PaneDescriptor)serializable).m_paneName, this.m_dataBeans, jPanel);
                        ((DeckPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(((PaneDescriptor)serializable).m_paneName, paneManager);
                        string2 = ((DeckPaneManager)paneManager).getTitle();
                    } else if (((PaneDescriptor)serializable).m_paneType.equals("TAB")) {
                        paneManager = new TabbedPaneManager(((PaneDescriptor)serializable).m_baseName, this.m_locale, ((PaneDescriptor)serializable).m_paneName, this.m_dataBeans, jPanel);
                        ((TabbedPaneManager)paneManager).setAggregateManager(this);
                        this.m_panels.addElement(paneManager);
                        this.m_panelTable.put(((PaneDescriptor)serializable).m_paneName, paneManager);
                        string2 = ((TabbedPaneManager)paneManager).getTitle();
                    }
                }
                this.m_tabbedPane.addTab(string2, jPanel);
            }
            ++n;
        }
    }

    private void debug(String string) {
        if (m_descriptorTrace) {
            System.out.println("TabbedPaneManager: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

