/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spinner;

import com.ibm.spinner.Spinner;
import com.ibm.spinner.SpinnerErrorEvent;
import com.ibm.spinner.SpinnerErrorEventListener;
import com.ibm.spinner.SpinnerErrorMessageSource;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumericSpinner
extends Spinner
implements ChangeListener {
    private BoundedRangeModel dataModel = new DefaultBoundedRangeModel();
    private int increment = 1;
    private boolean changeMode = false;
    private String fieldAboutThisBean = new String();
    private boolean bFirstThread = false;
    protected boolean bTypeMode = false;
    protected boolean bExitingTyping = false;
    protected int iLastValid = 0;
    protected boolean bInitializing = false;
    protected int iInitializing = 0;
    static Class class$com$ibm$spinner$SpinnerErrorEventListener;
    static Class class$javax$swing$event$ChangeListener;

    public NumericSpinner() {
        this(0, 0, 100, 1);
    }

    public NumericSpinner(int n) {
        this(0, 0, 100, n);
    }

    public NumericSpinner(int n, int n2) {
        this(n, n, n2, 1);
    }

    public NumericSpinner(int n, int n2, int n3, int n4) {
        this.increment = n4;
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, n2, n3);
        this.setModel(defaultBoundedRangeModel);
    }

    protected boolean acceptInput() {
        boolean bl;
        if (this.textField.getText().trim().equals("")) {
            this.textField.setText(new String("0"));
        }
        if (!(bl = this.validateInput(this.textField.getText()))) {
            this.fireSpinnerErrorEvent(this, 1, new Exception());
            return false;
        }
        try {
            this.setValue(Integer.valueOf(this.textField.getText()));
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.textField.setText(new Integer(this.getValue()).toString());
            this.fireSpinnerErrorEvent(this, 1, illegalArgumentException);
            return false;
        }
    }

    protected boolean acceptTypedInput() {
        String string = this.textField.getText();
        if (string.trim().equals("")) {
            this.fireSpinnerErrorEvent(this, 1, new Exception());
            return false;
        }
        try {
            this.iLastValid = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fireSpinnerErrorEvent(this, 1, new Exception());
            return false;
        }
        if (this.iLastValid > this.getMaximum() || this.iLastValid < this.getMinimum()) {
            this.fireSpinnerErrorEvent(this, 2, new Exception());
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
    }

    private int diffValue(int n, int n2) {
        int n3 = n2 - n;
        int n4 = 0;
        if (n3 > 0) {
            n4 = 1;
        } else if (n3 < 0) {
            n4 = 2;
        }
        return n4;
    }

    protected void enterTypeMode() {
        this.bTypeMode = true;
        this.bExitingTyping = false;
        if (this.getValue() == 0) {
            this.textField.setText("");
        }
        this.iLastValid = this.getValue();
    }

    protected boolean exitTypeMode() {
        boolean bl = false;
        if (this.bTypeMode) {
            this.bTypeMode = false;
            this.bExitingTyping = true;
            bl = this.acceptInput();
            this.bExitingTyping = false;
        }
        return bl;
    }

    protected void fireSpinnerErrorEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$com$ibm$spinner$SpinnerErrorEventListener;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.ibm.spinner.SpinnerErrorEventListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((SpinnerErrorEventListener)objectArray[n + 1]).internalError(new SpinnerErrorEvent(this, 1, new IllegalArgumentException()));
            }
            n -= 2;
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class<?> clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ChangeListener)objectArray[n + 1]).stateChanged(new ChangeEvent(this));
            }
            n -= 2;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.exitTypeMode();
    }

    public String getAboutThisBean() {
        return String.valueOf(this.getClass().getName()) + "^NumericSpinner^4.0^" + "NumericSpinner_About_Bean.gif^" + "Common_Spinner's_Features.gif^" + "NumericSpinner_Wiring_Example.gif^" + "/spinner/docs/index.html";
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public Font getFont() {
        return super.getFont();
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public BoundedRangeModel getModel() {
        return this.dataModel;
    }

    public int getValue() {
        if (!this.isTypeMode()) {
            return this.getModel().getValue();
        }
        this.acceptTypedInput();
        return this.iLastValid;
    }

    public void initMaximum(int n) {
        this.bInitializing = true;
        if (!Beans.isDesignTime()) {
            ++this.iInitializing;
        }
        if (this.getMinimum() >= n) {
            this.setMinimum(n - 1);
        }
        this.setMaximum(n);
        this.bInitializing = false;
    }

    public void initMinimum(int n) {
        this.bInitializing = true;
        if (!Beans.isDesignTime()) {
            ++this.iInitializing;
        }
        if (this.getMaximum() <= n) {
            this.setMaximum(n + 1);
        }
        this.setMinimum(n);
        this.bInitializing = false;
    }

    public boolean isEditable() {
        return super.isEditable();
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isSpinnable() {
        return super.isSpinnable();
    }

    protected boolean isTypeMode() {
        return this.bTypeMode;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || !this.getEditable()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        keyEvent.getKeyChar();
        if (this.isTypeMode() && keyEvent.isActionKey() && n != 8 || n == 10) {
            this.exitTypeMode();
        }
        if (!(this.isTypeMode() || n != 8 && n != 127)) {
            this.enterTypeMode();
        }
        super.keyPressed(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || !this.getEditable()) {
            return;
        }
        keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        String string = null;
        int n = -1;
        switch (c) {
            case '+': {
                string = this.textField.getText();
                if (string.startsWith("-")) {
                    try {
                        this.textField.setText(string.substring(1));
                        if (!this.isTypeMode()) {
                            n = 0;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                }
                keyEvent.consume();
                break;
            }
            case '-': {
                string = this.textField.getText();
                if (!string.startsWith("-")) {
                    this.textField.setText(new String("-" + string));
                    if (!this.isTypeMode()) {
                        n = 1;
                        if (this.getValue() == 0) {
                            this.enterTypeMode();
                            this.textField.setText(new String("-"));
                        }
                    }
                }
                keyEvent.consume();
            }
        }
        if (this.isTypeMode()) {
            if (keyEvent.isActionKey()) {
                this.exitTypeMode();
            }
        } else if (Character.isDigit(c)) {
            this.enterTypeMode();
        } else {
            keyEvent.consume();
        }
        super.keyTyped(keyEvent);
        try {
            if (!this.isTypeMode()) {
                Integer.valueOf(this.textField.getText());
                if (this.acceptInput() && n >= 0) {
                    this.textField.setCaretPosition(n);
                }
            } else {
                this.acceptTypedInput();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.textField.setText(new Integer(this.getValue()).toString());
            return;
        }
    }

    public void scrollDown() {
        if (this.isTypeMode()) {
            this.exitTypeMode();
        }
        super.scrollDown();
        int n = this.getValue();
        try {
            this.changeMode = true;
            this.setValue(n - this.increment);
            this.changeMode = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void scrollUp() {
        if (this.isTypeMode()) {
            this.exitTypeMode();
        }
        super.scrollUp();
        int n = this.getValue();
        try {
            this.changeMode = true;
            this.setValue(n + this.increment);
            this.changeMode = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void setAboutThisBean(String string) {
        this.fieldAboutThisBean = string;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setIncrement(int n) {
        int n2 = this.increment;
        if (n <= 0) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        this.increment = n;
        this.firePropertyChange("increment", n2, n);
    }

    public void setMaximum(int n) {
        int n2 = this.dataModel.getMaximum();
        int n3 = this.dataModel.getValue();
        int n4 = this.dataModel.getMinimum();
        if (n < n4) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        if (n != n2) {
            int n5;
            this.dataModel.setMaximum(n);
            this.textField.setText(new Integer(this.getValue()).toString());
            if (!(this.bInitializing && this.iInitializing <= 1 || (n5 = n - this.dataModel.getMinimum()) >= this.increment)) {
                this.setIncrement(1);
            }
            this.firePropertyChange("maximum", n2, n);
            if (n3 != this.getValue()) {
                this.fireValueChangedEvent(this.diffValue(n3, this.getValue()));
            }
        }
    }

    public void setMinimum(int n) {
        int n2 = this.dataModel.getMinimum();
        int n3 = this.dataModel.getValue();
        int n4 = this.dataModel.getMaximum();
        if (n > n4) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
        }
        if (n != n2) {
            int n5;
            this.dataModel.setMinimum(n);
            this.textField.setText(new Integer(this.getValue()).toString());
            if (!(this.bInitializing && this.iInitializing <= 1 || (n5 = this.dataModel.getMaximum() - n) >= this.increment)) {
                this.setIncrement(1);
            }
            this.firePropertyChange("minimum", n2, n);
            if (n3 != this.getValue()) {
                this.fireValueChangedEvent(this.diffValue(n3, this.getValue()));
            }
        }
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel == null) {
            throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("NullPointerParameter"));
        }
        if (boundedRangeModel != this.dataModel) {
            BoundedRangeModel boundedRangeModel2 = this.dataModel;
            boundedRangeModel2.removeChangeListener(this);
            this.dataModel = boundedRangeModel;
            this.dataModel.addChangeListener(this);
            int n = this.getValue();
            int n2 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            if (n2 < this.increment) {
                this.setIncrement(n2);
            }
            this.textField.setText(new Integer(this.getValue()).toString());
            this.firePropertyChange("model", boundedRangeModel2, this.dataModel);
            if (n != this.getValue()) {
                this.fireValueChangedEvent(this.diffValue(n, this.getValue()));
            }
        }
    }

    public void setSpinnable(boolean bl) {
        super.setSpinnable(bl);
    }

    public void setValue(int n) {
        int n2 = this.dataModel.getValue();
        if (this.isWrap()) {
            if (this.changeMode) {
                int n3 = n;
                if (n > this.getMaximum()) {
                    n3 = this.getMinimum();
                }
                if (n < this.getMinimum()) {
                    n3 = this.getMaximum();
                }
                this.dataModel.setValue(n3);
            } else {
                if (n < this.getMinimum() || n > this.getMaximum()) {
                    throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
                }
                this.dataModel.setValue(n);
            }
        } else {
            if (n < this.getMinimum() || n > this.getMaximum()) {
                throw new IllegalArgumentException(SpinnerErrorMessageSource.getStringBy("OutOfRange"));
            }
            this.dataModel.setValue(n);
        }
        this.textField.setText(new Integer(this.getValue()).toString());
        this.firePropertyChange("value", n2, this.getValue());
        this.fireValueChangedEvent(this.diffValue(n2, this.getValue()));
    }

    private boolean validateInput(String string) {
        int n;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.textField.setText(new Integer(this.getValue()).toString());
            return false;
        }
        if (n <= this.getMaximum() && n >= this.getMinimum()) {
            return true;
        }
        this.textField.setText(new Integer(this.getValue()).toString());
        return false;
    }
}

