/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLParameter;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLApplet
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 3578237003243756490L;
    private String archive_;
    private String code_;
    private String codebase_;
    private int width_;
    private int height_;
    private String text_ = ResourceBundleLoader_h.getText("PROP_DESC_APPLET_ALTTEXT");
    private Vector list_;
    private static ResourceBundleLoader_h loader_;
    private transient Vector elementListeners;

    public HTMLApplet() {
        this.list_ = new Vector();
    }

    public HTMLApplet(String string) {
        this.setCode(string);
        this.list_ = new Vector();
    }

    public HTMLApplet(String string, int n, int n2) {
        this.setCode(string);
        this.setWidth(n);
        this.setHeight(n2);
        this.list_ = new Vector();
    }

    public HTMLApplet(String string, String string2, int n, int n2) {
        this.setCode(string);
        this.setCodebase(string2);
        this.setWidth(n);
        this.setHeight(n2);
        this.list_ = new Vector();
    }

    public HTMLApplet(String string, String string2, String string3, int n, int n2) {
        this.setArchive(string);
        this.setCode(string2);
        this.setCodebase(string3);
        this.setWidth(n);
        this.setHeight(n2);
        this.list_ = new Vector();
    }

    public void addParameter(HTMLParameter hTMLParameter) {
        if (hTMLParameter == null) {
            throw new NullPointerException("param");
        }
        this.list_.addElement(hTMLParameter);
        this.fireElementEvent(0);
    }

    public HTMLParameter addParameter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        HTMLParameter hTMLParameter = new HTMLParameter(string, string2);
        this.list_.addElement(hTMLParameter);
        this.fireElementEvent(0);
        return hTMLParameter;
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getArchive() {
        return this.archive_;
    }

    public String getCode() {
        return this.code_;
    }

    public String getCodebase() {
        return this.codebase_;
    }

    public int getHeight() {
        return this.height_;
    }

    public String getText() {
        return this.text_;
    }

    public int getWidth() {
        return this.width_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLApplet was here -->";
    }

    public String getTag() {
        if (this.code_ == null) {
            Trace.log(2, "Attempting to get tag before setting applet code.");
            throw new ExtendedIllegalStateException("code", 4);
        }
        if (this.width_ <= 0) {
            Trace.log(2, "Attempting to get tag before setting applet width.");
            throw new ExtendedIllegalStateException("width", 4);
        }
        if (this.height_ <= 0) {
            Trace.log(2, "Attempting to get tag before setting applet height.");
            throw new ExtendedIllegalStateException("height", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<applet");
        if (this.codebase_ != null) {
            stringBuffer.append(" codebase=\"" + this.getCodebase() + "\"");
        }
        stringBuffer.append(" code=\"" + this.getCode() + "\"");
        stringBuffer.append(" width=\"" + this.getWidth() + "\"");
        stringBuffer.append(" height=\"" + this.getHeight() + "\"");
        if (this.archive_ != null) {
            stringBuffer.append(" archive=\"" + this.getArchive() + "\"");
        }
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLParameter hTMLParameter = (HTMLParameter)this.list_.elementAt(i);
            stringBuffer.append(hTMLParameter.getTag());
        }
        stringBuffer.append(this.getText() + "\n");
        stringBuffer.append("</applet>\n");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeParameter(HTMLParameter hTMLParameter) {
        if (hTMLParameter == null) {
            throw new NullPointerException("param");
        }
        if (this.list_.removeElement(hTMLParameter)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void setCodebase(String string) {
        if (string == null) {
            throw new NullPointerException("codebase");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("codebase", 1);
        }
        String string2 = this.codebase_;
        this.codebase_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("codebase", string2, string);
        }
    }

    public void setArchive(String string) {
        if (string == null) {
            throw new NullPointerException("archive");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("archive", 1);
        }
        String string2 = this.archive_;
        this.archive_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("archive", string2, string);
        }
    }

    public void setCode(String string) {
        if (string == null) {
            throw new NullPointerException("code");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("code", 1);
        }
        String string2 = this.code_;
        this.code_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("code", string2, string);
        }
    }

    public void setHeight(int n) {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int n2 = this.height_;
        this.height_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", new Integer(n2), new Integer(n));
        }
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String string2 = this.text_;
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public void setWidth(int n) {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int n2 = this.width_;
        this.width_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Integer(n2), new Integer(n));
        }
    }

    public String toString() {
        return this.getTag();
    }
}

