/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HiddenFormInput;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class HTMLForm
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7610016051219431008L;
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    private Vector list_ = new Vector();
    private String url_;
    private String target_;
    private Properties parms_;
    private boolean useGet_ = true;
    private int method_ = 0;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public HTMLForm() {
    }

    public HTMLForm(String string) {
        this();
        try {
            this.setURL(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        this.list_.addElement(hTMLTagElement);
        this.fireElementEvent(0);
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public Properties getHiddenParameterList() {
        return this.parms_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public int getMethod() {
        return this.method_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLForm was here -->";
    }

    public String getTag() {
        Object object;
        if (this.url_ == null) {
            Trace.log(2, "Attempting to get tag before setting the action URL address.");
            throw new ExtendedIllegalStateException("url", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<form action=\"");
        stringBuffer.append(this.url_);
        stringBuffer.append("\"");
        if (this.method_ == 1) {
            stringBuffer.append(" method=\"post\"");
        } else {
            stringBuffer.append(" method=\"get\"");
        }
        if (this.target_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using target frame.");
            }
            stringBuffer.append(" target=\"");
            stringBuffer.append(this.target_);
            stringBuffer.append("\"");
        }
        if (this.lang_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            stringBuffer.append(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
        }
        if (this.dir_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            stringBuffer.append(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        if (this.parms_ != null) {
            Enumeration<?> enumeration = this.parms_.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string = this.parms_.getProperty((String)object);
                HiddenFormInput hiddenFormInput = new HiddenFormInput();
                try {
                    hiddenFormInput.setName((String)object);
                    hiddenFormInput.setValue(string);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.addElement(hiddenFormInput);
            }
        }
        for (int i = 0; i < this.list_.size(); ++i) {
            object = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(object.getTag());
            stringBuffer.append("\n");
        }
        stringBuffer.append("</form>");
        return stringBuffer.toString();
    }

    public String getTarget() {
        return this.target_;
    }

    public String getURL() {
        return this.url_;
    }

    public boolean isUseGet() {
        return this.method_ == 0;
    }

    public boolean isUsePost() {
        return this.method_ == 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        if (this.list_.removeElement(hTMLTagElement)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setHiddenParameterList(Properties properties) throws PropertyVetoException {
        if (properties == null) {
            throw new NullPointerException("parameterList");
        }
        Properties properties2 = this.parms_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("parameterList", properties2, properties);
        }
        this.parms_ = properties;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("parameterList", properties2, properties);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setMethod(int n) throws PropertyVetoException {
        if (n < 0 || n > 1) {
            throw new ExtendedIllegalArgumentException("method", 2);
        }
        int n2 = this.method_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("method", new Integer(n2), new Integer(n));
        }
        this.method_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("method", new Integer(n2), new Integer(n));
        }
    }

    public void setTarget(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("target");
        }
        String string2 = this.target_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("target", string2, string);
        }
        this.target_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("target", string2, string);
        }
    }

    public void setURL(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("url");
        }
        String string2 = this.url_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("url", string2, string);
        }
        this.url_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

