/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class HTMLHyperlink
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 83601853360783566L;
    private String bookmarkName_;
    private String link_;
    private Properties properties_;
    private String target_;
    private String text_;
    private String title_;
    private String location_;
    private String lang_;
    private String dir_;
    transient VetoableChangeSupport vetos_;

    public HTMLHyperlink() {
    }

    public HTMLHyperlink(String string) {
        if (string == null) {
            throw new NullPointerException("link");
        }
        this.link_ = string;
    }

    public HTMLHyperlink(String string, String string2) {
        this(string);
        if (string2 == null) {
            throw new NullPointerException("text");
        }
        this.text_ = string2;
    }

    public HTMLHyperlink(String string, String string2, String string3) {
        this(string, string2);
        if (string3 == null) {
            throw new NullPointerException("target");
        }
        this.target_ = string3;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public Object clone() {
        HTMLHyperlink hTMLHyperlink = new HTMLHyperlink();
        try {
            if (this.location_ != null) {
                hTMLHyperlink.setLocation(this.location_);
            }
            if (this.properties_ != null) {
                hTMLHyperlink.setProperties(this.properties_);
            }
            if (this.getAttributes() != null) {
                hTMLHyperlink.setAttributes(this.getAttributes());
            }
            if (this.link_ != null) {
                hTMLHyperlink.setLink(this.link_);
            }
            if (this.target_ != null) {
                hTMLHyperlink.setTarget(this.target_);
            }
            if (this.text_ != null) {
                hTMLHyperlink.setText(this.text_);
            }
            if (this.title_ != null) {
                hTMLHyperlink.setTitle(this.title_);
            }
            if (this.dir_ != null) {
                hTMLHyperlink.setDirection(this.dir_);
            }
            if (this.lang_ != null) {
                hTMLHyperlink.setLanguage(this.lang_);
            }
            if (this.bookmarkName_ != null) {
                hTMLHyperlink.setName(this.bookmarkName_);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return hTMLHyperlink;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getLink() {
        return this.link_;
    }

    public String getLocation() {
        return this.location_;
    }

    public String getName() {
        return this.bookmarkName_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getTarget() {
        return this.target_;
    }

    public String getText() {
        return this.text_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLHyperlink was here -->";
    }

    public String getTag() {
        return this.getTag(this.text_, this.properties_);
    }

    public String getTag(String string, Properties properties) {
        return this.getTag(string, this.bookmarkName_, this.link_, properties);
    }

    public String getTag(String string, String string2, String string3, Properties properties) {
        if (string3 == null) {
            Trace.log(2, "Attempting to get tag before setting the link.");
            throw new ExtendedIllegalStateException("link", 4);
        }
        if (string == null) {
            throw new NullPointerException("text");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=\"");
        stringBuffer.append(string3);
        if (properties != null) {
            String string4 = "?";
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                stringBuffer.append(string4);
                stringBuffer.append(URLEncoder.encode(string5));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(properties.getProperty(string5)));
                string4 = "&";
            }
        }
        if (this.location_ != null) {
            stringBuffer.append("#");
            stringBuffer.append(this.location_);
        }
        stringBuffer.append("\"");
        if (string2 != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        if (this.title_ != null) {
            stringBuffer.append(" title=\"");
            stringBuffer.append(this.title_);
            stringBuffer.append("\"");
        }
        if (this.target_ != null) {
            stringBuffer.append(" target=\"");
            stringBuffer.append(this.target_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append("</a>");
        return new String(stringBuffer);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setLocation(String string) {
        if (string == null) {
            throw new NullPointerException("location");
        }
        String string2 = this.location_;
        this.location_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("location", string2, string);
        }
    }

    public void setLink(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("link");
        }
        String string2 = this.link_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("link", string2, string);
        }
        this.link_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("link", string2, string);
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.bookmarkName_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string);
        }
        this.bookmarkName_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setProperties(Properties properties) throws PropertyVetoException {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        Properties properties2 = this.properties_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("properties", properties2, properties);
        }
        this.properties_ = properties;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("properties", properties2, properties);
        }
    }

    public void setTarget(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("target");
        }
        String string2 = this.target_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("target", string2, string);
        }
        this.target_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("target", string2, string);
        }
    }

    public void setText(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", string2, string);
        }
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public void setTitle(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("title");
        }
        String string2 = this.title_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("title", string2, string);
        }
        this.title_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("title", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

