/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class HTMLListItem
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7139184882249518511L;
    private HTMLTagElement listData_;
    private String lang_;
    private String dir_;
    boolean useFO_ = false;
    private String type_;

    abstract String getTypeAttribute();

    abstract String getTypeAttributeFO(String var1, int var2);

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public HTMLTagElement getItemData() {
        return this.listData_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        StringBuffer stringBuffer = new StringBuffer("<li");
        stringBuffer.append(this.getTypeAttribute());
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">");
        stringBuffer.append(this.listData_.getTag());
        stringBuffer.append("</li>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">");
        stringBuffer.append(this.listData_.getFOTag());
        stringBuffer.append("</fo:block-container>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setItemData(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("data");
        }
        HTMLTagElement hTMLTagElement2 = this.listData_;
        this.listData_ = hTMLTagElement;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("data", hTMLTagElement2, hTMLTagElement);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

