/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLTableCell
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -4848852026390616957L;
    private HTMLTagElement element_;
    private String align_;
    private int colSpan_ = 1;
    private int height_;
    private int rowSpan_ = 1;
    private String vAlign_;
    private int width_;
    private boolean wrap_ = true;
    private String lang_;
    private String dir_;
    private boolean heightPercent_ = false;
    private boolean widthPercent_ = false;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableCell() {
    }

    public HTMLTableCell(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        this.element_ = hTMLTagElement;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public int getColumnSpan() {
        return this.colSpan_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public HTMLTagElement getElement() {
        return this.element_;
    }

    String getEndTag() {
        if (!this.useFO_) {
            return "</td>\n";
        }
        return "</fo:table-cell>\n";
    }

    public int getHeight() {
        return this.height_;
    }

    public String getHorizontalAlignment() {
        return this.align_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getRowSpan() {
        return this.rowSpan_;
    }

    String getStartTag() {
        if (!this.useFO_) {
            return "<td";
        }
        return "<fo:table-cell border-style='solid' border-width='" + this.borderWidth_ + "px' padding='" + this.cellPadding_ + "px'";
    }

    String getAttributeTag() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.align_ != null) {
            if (!this.useFO_) {
                stringBuffer.append(" align=\"");
                stringBuffer.append(this.align_);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(" text-align='");
                if (this.align_.equalsIgnoreCase("center")) {
                    stringBuffer.append("center");
                } else if (this.align_.equalsIgnoreCase("left")) {
                    stringBuffer.append("start");
                } else if (this.align_.equalsIgnoreCase("right")) {
                    stringBuffer.append("end");
                }
                stringBuffer.append("'");
            }
        }
        if (!this.useFO_) {
            if (this.vAlign_ != null) {
                stringBuffer.append(" valign=\"");
                stringBuffer.append(this.vAlign_);
                stringBuffer.append("\"");
            }
            if (this.rowSpan_ > 1) {
                stringBuffer.append(" rowspan=\"");
                stringBuffer.append(this.rowSpan_);
                stringBuffer.append("\"");
            }
            if (this.colSpan_ > 1) {
                stringBuffer.append(" colspan=\"");
                stringBuffer.append(this.colSpan_);
                stringBuffer.append("\"");
            }
            if (this.height_ > 0) {
                stringBuffer.append(" height=\"");
                stringBuffer.append(this.height_);
                if (this.heightPercent_) {
                    stringBuffer.append("%");
                }
                stringBuffer.append("\"");
            }
            if (this.width_ > 0) {
                stringBuffer.append(" width=\"");
                stringBuffer.append(this.width_);
                if (this.widthPercent_) {
                    stringBuffer.append("%");
                }
                stringBuffer.append("\"");
            }
            if (!this.wrap_) {
                stringBuffer.append(" nowrap=\"nowrap\"");
            }
            stringBuffer.append(this.getLanguageAttributeTag());
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(this.getAttributeString());
        } else {
            if (this.rowSpan_ > 1) {
                stringBuffer.append(" number-rows-spanned='");
                stringBuffer.append(this.rowSpan_);
                stringBuffer.append("'");
            }
            if (this.colSpan_ > 1) {
                stringBuffer.append(" number-columns-spanned='");
                stringBuffer.append(this.colSpan_);
                stringBuffer.append("'");
            }
            if (this.height_ > 0) {
                stringBuffer.append(" height='");
                stringBuffer.append(this.height_);
                if (this.heightPercent_) {
                    stringBuffer.append("%");
                }
                stringBuffer.append("'");
            }
            if (this.width_ > 0) {
                stringBuffer.append(" width='");
                stringBuffer.append(this.width_);
                if (this.widthPercent_) {
                    stringBuffer.append("%");
                }
                stringBuffer.append("'");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getTag() {
        return this.getTag(this.element_);
    }

    public String getFOTag() {
        return this.getFOTag(this.element_);
    }

    public String getFOTag(HTMLTagElement hTMLTagElement) {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        StringBuffer stringBuffer = new StringBuffer(this.getStartTag());
        stringBuffer.append(this.getAttributeTag());
        stringBuffer.append("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        stringBuffer.append(hTMLTagElement.getFOTag());
        stringBuffer.append("</fo:block-container>\n");
        stringBuffer.append(this.getEndTag());
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public String getTag(HTMLTagElement hTMLTagElement) {
        if (this.useFO_) {
            return this.getFOTag(hTMLTagElement);
        }
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        StringBuffer stringBuffer = new StringBuffer(this.getStartTag());
        stringBuffer.append(this.getAttributeTag());
        stringBuffer.append(hTMLTagElement.getTag());
        stringBuffer.append(this.getEndTag());
        return stringBuffer.toString();
    }

    public String getVerticalAlignment() {
        return this.vAlign_;
    }

    public int getWidth() {
        return this.width_;
    }

    public boolean isHeightInPercent() {
        return this.heightPercent_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public boolean isWidthInPercent() {
        return this.widthPercent_;
    }

    public boolean isWrap() {
        return this.wrap_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setColumnSpan(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("span", 4);
        }
        int n2 = this.colSpan_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("span", new Integer(n2), new Integer(n));
        }
        this.colSpan_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("span", new Integer(n2), new Integer(n));
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setElement(String string) throws PropertyVetoException {
        this.setElement(new HTMLText(string));
    }

    public void setElement(HTMLTagElement hTMLTagElement) throws PropertyVetoException {
        if (hTMLTagElement == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement hTMLTagElement2 = this.element_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("element", hTMLTagElement2, hTMLTagElement);
        }
        this.element_ = hTMLTagElement;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", hTMLTagElement2, hTMLTagElement);
        }
    }

    public void setHeight(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int n2 = this.height_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("height", new Integer(n2), new Integer(n));
        }
        this.height_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", new Integer(n2), new Integer(n));
        }
    }

    public void setHeight(int n, boolean bl) throws PropertyVetoException {
        int n2 = this.height_;
        this.setHeight(n);
        try {
            this.setHeightInPercent(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.height_ = n2;
            throw new PropertyVetoException("heightInPercent", propertyVetoException.getPropertyChangeEvent());
        }
    }

    public void setHeightInPercent(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.heightPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("heightInPercent", new Boolean(bl2), new Boolean(bl));
        }
        this.heightPercent_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("heightInPercent", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setHorizontalAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("left") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("right")) {
            String string2 = this.align_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.align_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setRowSpan(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("span", 4);
        }
        int n2 = this.rowSpan_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("span", new Integer(n2), new Integer(n));
        }
        this.rowSpan_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("span", new Integer(n2), new Integer(n));
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public void setBorderWidth(int n) {
        Integer n2 = new Integer(this.borderWidth_);
        Integer n3 = new Integer(n);
        this.borderWidth_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", n2, n3);
        }
    }

    public void setCellPadding(int n) {
        Integer n2 = new Integer(this.cellPadding_);
        Integer n3 = new Integer(n);
        this.cellPadding_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", n2, n3);
        }
    }

    public void setVerticalAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("top") || string.equalsIgnoreCase("middle") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("baseline")) {
            String string2 = this.vAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.vAlign_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setWidth(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int n2 = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", new Integer(n2), new Integer(n));
        }
        this.width_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Integer(n2), new Integer(n));
        }
    }

    public void setWidth(int n, boolean bl) throws PropertyVetoException {
        int n2 = this.width_;
        this.setWidth(n);
        try {
            this.setWidthInPercent(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.width_ = n2;
            throw new PropertyVetoException("widthInPercent", propertyVetoException.getPropertyChangeEvent());
        }
    }

    public void setWidthInPercent(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.widthPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("widthInPercent", new Boolean(bl2), new Boolean(bl));
        }
        this.widthPercent_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("widthInPercent", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setWrap(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.wrap_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("wrap", new Boolean(bl2), new Boolean(bl));
        }
        this.wrap_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("wrap", new Boolean(bl2), new Boolean(bl));
        }
    }

    public String toString() {
        return this.getTag();
    }
}

