/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.RadioFormInput;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class RadioFormInputGroup
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1787781415625086189L;
    private String name_;
    private Vector list_;
    private boolean useVertAlign_ = false;
    private boolean groupCheck_ = false;
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public RadioFormInputGroup() {
        this.list_ = new Vector();
    }

    public RadioFormInputGroup(String string) {
        try {
            this.setName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.list_ = new Vector();
    }

    public void add(RadioFormInput radioFormInput) {
        if (radioFormInput == null) {
            throw new NullPointerException("radioButton");
        }
        if (this.name_ == null) {
            this.name_ = radioFormInput.getName();
        } else {
            try {
                radioFormInput.setName(this.name_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.groupCheck_ && radioFormInput.isChecked()) {
            Trace.log(2, "Previous RadioButton marked as 'checked'.");
            throw new ExtendedIllegalArgumentException("checked", 2);
        }
        if (!this.groupCheck_ && radioFormInput.isChecked()) {
            this.groupCheck_ = true;
        }
        this.list_.addElement(radioFormInput);
        this.fireElementEvent(0);
    }

    public RadioFormInput add(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        if (string3 == null) {
            throw new NullPointerException("label");
        }
        RadioFormInput radioFormInput = new RadioFormInput(string, string2, string3, bl);
        if (this.name_ == null) {
            this.name_ = string;
        } else {
            try {
                radioFormInput.setName(this.name_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.groupCheck_ && radioFormInput.isChecked()) {
            Trace.log(2, "Previous RadioButton marked as 'checked'.");
            throw new ExtendedIllegalArgumentException("checked", 2);
        }
        if (!this.groupCheck_ && radioFormInput.isChecked()) {
            this.groupCheck_ = true;
        }
        this.list_.addElement(radioFormInput);
        this.fireElementEvent(0);
        return radioFormInput;
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A RadioFormInputGroup was here -->";
    }

    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        this.groupCheck_ = false;
        Properties properties = null;
        Properties properties2 = this.getAttributes();
        for (int i = 0; i < this.list_.size(); ++i) {
            RadioFormInput radioFormInput = (RadioFormInput)this.list_.elementAt(i);
            properties = radioFormInput.getAttributes();
            if (properties == null && properties2 != null) {
                radioFormInput.setAttributes(properties2);
            }
            stringBuffer.append(radioFormInput.getTag());
            if (this.useVertAlign_) {
                stringBuffer.append(" <br />");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean isAlignmentVertical() {
        return this.useVertAlign_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void remove(RadioFormInput radioFormInput) {
        if (radioFormInput == null) {
            throw new NullPointerException("radioButton");
        }
        if (radioFormInput.isChecked()) {
            this.groupCheck_ = false;
        }
        if (this.list_.removeElement(radioFormInput)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string);
        }
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setVerticalAlignment(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.useVertAlign_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("verticalAlignment", new Boolean(bl2), new Boolean(bl));
        }
        this.useVertAlign_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("verticalAlignment", new Boolean(bl2), new Boolean(bl));
        }
    }
}

