/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SelectOption
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3056147198368434425L;
    private String value_;
    private boolean selected_;
    private String text_;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;

    public SelectOption() {
        this.selected_ = false;
    }

    public SelectOption(String string, String string2) {
        try {
            this.setValue(string2);
            this.setText(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public SelectOption(String string, String string2, boolean bl) {
        try {
            this.setValue(string2);
            this.setSelected(bl);
            this.setText(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A SelectOption was here -->";
    }

    public String getTag() {
        return this.getTag(this.text_);
    }

    public String getTag(String string) {
        StringBuffer stringBuffer = new StringBuffer("<option");
        if (this.value_ != null) {
            stringBuffer.append(" value=\"");
            stringBuffer.append(this.value_);
            stringBuffer.append("\"");
        }
        if (this.selected_) {
            stringBuffer.append(" selected=\"selected\"");
        }
        if (this.lang_ != null && this.lang_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            stringBuffer.append(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            stringBuffer.append(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">");
        if (string == null) {
            Trace.log(2, "Parameter 'text' is null.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        stringBuffer.append(string);
        stringBuffer.append("</option>");
        return stringBuffer.toString();
    }

    public String getText() {
        return this.text_;
    }

    public String getValue() {
        return this.value_;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.selected_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("selected", new Boolean(bl2), new Boolean(bl));
        }
        this.selected_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("selected", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setText(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", string2, string);
        }
        this.text_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", string2, string);
        }
    }

    public void setValue(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("value");
        }
        String string2 = this.value_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("value", string2, string);
        }
        this.value_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

