/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.properties.AreaAlignmentProperty;
import com.ibm.xsl.composer.properties.PropertyMap;

public class AlignmentBehavior
extends AreaBehavior {
    private long baselineOffset = 0L;

    protected void doAdjustAvailable(Extent cur) {
        cur.bpd -= this.baselineOffset;
    }

    protected long doAdjustBaseline(long cur) {
        return cur + this.baselineOffset;
    }

    protected void doAdjustExtent(Extent cur) {
        cur.bpd += this.baselineOffset;
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        AreaAlignmentProperty ap = properties.getAreaAlignmentProperty();
        long[] units = composeInfo.getUnitsForProperties(properties);
        if (!ap.isAutoAlignmentAdjust()) {
            this.baselineOffset = ap.getAlignmentAdjust().getNormalizedLength(units);
        }
    }

    public String toString() {
        return "<alignment-behavior><baseline-offset>" + this.baselineOffset + "</baseline-offset></alignment-behavior>";
    }
}

