/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.PropertyMap;

public class BackgroundBehavior
extends AreaBehavior {
    private CSSColor backgroundColor;

    public BackgroundBehavior() {
        super("background-behavior");
    }

    public String diagnostic() {
        return "<background-color>" + this.backgroundColor + "</background-color>";
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        BorderPaddingBackgroundProperty bp = properties.getBorderPaddingBackgroundProperty();
        this.backgroundColor = bp.getBackgroundColor();
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        CSSPoint copyLocation = new CSSPoint(location.x, location.y);
        CSSExtent copyExtent = new CSSExtent(extent.width, extent.height);
        CSSColor bgColor = this.backgroundColor;
        context.fillBackground(copyLocation, copyExtent, bgColor);
    }
}

