/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.csstypes.Repeat;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.net.URL;

public class BackgroundImageBehavior
extends AreaBehavior {
    private URL backgroundImage;
    private Repeat backgroundRepeat;
    private CSSLength backgroundPositionHorizontal;
    private CSSLength backgroundPositionVertical;
    private long[] units;

    public String diagnostic() {
        return "<background-image>" + this.backgroundImage + "</background-image><background-repeat>" + this.backgroundRepeat + "</background-repeat><position-horizontal>" + this.backgroundPositionHorizontal + "</position-horizontal><position-vertical>" + this.backgroundPositionVertical + "</position-vertical>";
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        BorderPaddingBackgroundProperty bp = properties.getBorderPaddingBackgroundProperty();
        this.backgroundRepeat = bp.getBackgroundRepeat();
        this.backgroundImage = bp.getBackgroundImage();
        this.backgroundPositionHorizontal = bp.getBackgroundPostionHorizontal();
        this.backgroundPositionVertical = bp.getBackgroundPostionVertical();
        this.units = composeInfo.getUnitsForProperties(properties);
        composeInfo.context.notifyGraphic(this.backgroundImage);
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        CSSPoint offset = new CSSPoint(this.backgroundPositionHorizontal.getNormalizedLength(this.units), this.backgroundPositionVertical.getNormalizedLength(this.units));
        context.fillBackground(location, extent, this.backgroundImage.toExternalForm(), offset, this.backgroundRepeat.getValue());
    }
}

