/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Size;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.prim.Transform;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.ColorRelatedProperty;
import com.ibm.xsl.composer.properties.PropertyMap;

public class BorderBehavior
extends AreaBehavior {
    protected CSSColor color;
    protected Border borderBefore = new Border();
    protected Border borderAfter = new Border();
    protected Border borderStart = new Border();
    protected Border borderEnd = new Border();
    protected long paddingBefore;
    protected long paddingAfter;
    protected long paddingStart;
    protected long paddingEnd;

    public String diagnostic() {
        return String.valueOf(String.valueOf(this.color)) + "<border-before>" + this.borderBefore + "</border-before>" + "<border-after>" + this.borderAfter + "</border-after>" + "<border-start>" + this.borderStart + "</border-start>" + "<border-end>" + this.borderEnd + "</border-end>" + "<padding-before>" + this.paddingBefore + "</padding-before>" + "<padding-after>" + this.paddingAfter + "</padding-after>" + "<padding-start>" + this.paddingStart + "</padding-start>" + "<padding-end>" + this.paddingEnd + "</padding-end>";
    }

    protected void doAdjustAvailable(Extent cur) {
        cur.bpd -= this.borderBefore.width + this.borderAfter.width + this.paddingBefore + this.paddingAfter;
        cur.ipd -= this.borderStart.width + this.borderEnd.width + this.paddingStart + this.paddingEnd;
    }

    protected long doAdjustBaseline(long cur) {
        return cur + this.borderBefore.width + this.paddingBefore;
    }

    protected void doAdjustExtent(Extent cur) {
        cur.bpd += this.borderBefore.width + this.borderAfter.width + this.paddingBefore + this.paddingAfter;
        cur.ipd += this.borderStart.width + this.borderEnd.width + this.paddingStart + this.paddingEnd;
    }

    protected void doAdjustTransform(Transform tf, Extent content, FLOPoint location) {
        tf.translate(this.borderStart.width + this.paddingStart, this.borderBefore.width + this.paddingBefore);
    }

    protected void doElaborateRequest(SpaceRequest request, int direction) {
        Size extraSize = direction == 1 ? new Size(this.borderBefore.width + this.borderAfter.width + this.paddingBefore + this.paddingAfter) : new Size(this.borderStart.width + this.borderEnd.width + this.paddingStart + this.paddingEnd);
        request.area.sum(extraSize);
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        ColorRelatedProperty cp = properties.getColorRelatedProperty();
        this.color = cp.getColor();
        BorderPaddingBackgroundProperty bp = properties.getBorderPaddingBackgroundProperty();
        CSSColor borderColor = bp.getBorderBeforeColor();
        long[] units = composeInfo.getUnitsForProperties(properties);
        long width = bp.getBorderBeforeWidth().getNormalizedLength(units);
        short style = bp.getBorderBeforeStyle();
        this.setBorder(this.borderBefore, borderColor, width, style);
        borderColor = bp.getBorderAfterColor();
        width = bp.getBorderAfterWidth().getNormalizedLength(units);
        style = bp.getBorderAfterStyle();
        this.setBorder(this.borderAfter, borderColor, width, style);
        borderColor = bp.getBorderStartColor();
        width = bp.getBorderStartWidth().getNormalizedLength(units);
        style = bp.getBorderStartStyle();
        this.setBorder(this.borderStart, borderColor, width, style);
        borderColor = bp.getBorderEndColor();
        width = bp.getBorderEndWidth().getNormalizedLength(units);
        style = bp.getBorderEndStyle();
        this.setBorder(this.borderEnd, borderColor, width, style);
        this.paddingStart = bp.getPaddingStart().getNormalizedLength(units);
        this.paddingEnd = bp.getPaddingEnd().getNormalizedLength(units);
        this.paddingBefore = bp.getPaddingBefore().getNormalizedLength(units);
        this.paddingAfter = bp.getPaddingAfter().getNormalizedLength(units);
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        context.drawBorder(this.borderBefore, this.borderStart, this.borderAfter, this.borderEnd, location, extent);
    }

    private void setBorder(Border border, CSSColor color, long width, short style) {
        if (style != 0) {
            border.color = color == null ? this.color : color;
            border.width = width;
        } else {
            border.color = null;
            border.width = 0L;
        }
        border.style = style;
    }
}

