/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.areas.AreaTreeNode;
import com.ibm.xsl.composer.areas.AreaTreeVisitor;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.csstypes.SpaceCDT;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Space;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.prim.Transform;
import com.ibm.xsl.composer.properties.AreaDimensionProperty;
import com.ibm.xsl.composer.properties.MarginProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.ListIterator;

public class GeneralArea
extends AreaTreeNode {
    public static final int HIGHLIGHT_NONE = 0;
    public static final int HIGHLIGHT_PRIMARY = 1;
    public static final int HIGHLIGHT_SECONDARY = 2;
    public static final int HIGHLIGHT_COUNT = 3;
    protected FLOPoint location = new FLOPoint();
    protected Extent contentExtent = new Extent();
    protected boolean isIPDFixed = false;
    protected boolean isBPDFixed = false;
    private Space beforeSpace;
    private Space afterSpace;
    public Space startSpace;
    public Space endSpace;
    protected AreaBehavior behavior;
    private int highlightType = 0;
    public boolean isAbsolutePositioned = false;

    public final void addBehavior(AreaBehavior behavior) {
        if (this.behavior == null) {
            this.behavior = behavior;
        } else {
            this.behavior.addBehavior(behavior);
        }
    }

    public void addChild(AreaTreeNode child) {
        if (!(child instanceof GeneralArea)) {
            throw new IllegalArgumentException("Child must be a GeneralArea");
        }
        super.addChild(child);
    }

    public void adjustAvailable(Extent available) {
        if (this.beforeSpace != null && this.afterSpace != null) {
            available.bpd -= this.beforeSpace.getOptimum() + this.afterSpace.getOptimum();
        }
        if (this.startSpace != null && this.endSpace != null) {
            available.ipd -= this.startSpace.getOptimum() + this.endSpace.getOptimum();
        }
        if (this.behavior != null) {
            this.behavior.adjustAvailable(available);
        }
    }

    private void adjustExtent(Extent available) {
        if (this.behavior != null) {
            this.behavior.adjustExtent(available);
        }
    }

    protected void adjustTransform(Transform tf) {
        tf.translate(this.location.start, this.location.before);
        if (this.behavior != null) {
            this.behavior.adjustTransform(tf, this.getContentExtent(), this.location);
        }
    }

    public String diagnostic() {
        Object progenitor;
        String result = String.valueOf(this.location.toString()) + this.contentExtent.toString();
        if (this.behavior != null) {
            result = String.valueOf(result) + "<behaviors>" + this.behavior.describe() + "</behaviors>";
        }
        if ((progenitor = this.getProgenitor()) != null) {
            result = String.valueOf(result) + "<progenitor>" + progenitor + "</progenitor>";
        }
        return result;
    }

    public final void draw(Context context, Transform tf) {
        this.paint(context, tf);
        Transform selfTf = new Transform(tf);
        this.adjustTransform(selfTf);
        ListIterator it = this.getChildren();
        if (it.hasNext()) {
            while (it.hasNext()) {
                GeneralArea area = (GeneralArea)it.next();
                area.draw(context, selfTf);
            }
        }
    }

    public void elaborateRequest(SpaceRequest request, int direction) {
        request.setAfter(this.afterSpace);
        request.setBefore(this.beforeSpace);
        if (this.behavior != null) {
            this.behavior.elaborateRequest(request, direction);
        }
    }

    public void extendContentArea(FLOPoint location, Extent extent) {
        if (!this.isIPDFixed) {
            this.contentExtent.replaceIPDIfLarger(location.start + extent.ipd);
        }
        if (!this.isBPDFixed) {
            this.contentExtent.replaceBPDIfLarger(location.before + extent.bpd);
        }
    }

    public final AreaTreeNode findNodeAtLocation(Context context, Transform tf, CSSPoint point) {
        GeneralArea result = null;
        if (this.isHitPoint(context, tf, point)) {
            result = this;
        }
        Transform selfTf = new Transform(tf);
        this.adjustTransform(selfTf);
        AreaTreeNode moreSpecificResult = null;
        ListIterator li = this.getChildren();
        while (moreSpecificResult == null && li.hasNext()) {
            moreSpecificResult = ((GeneralArea)li.next()).findNodeAtLocation(context, selfTf, point);
        }
        if (moreSpecificResult != null) {
            result = moreSpecificResult;
        }
        return result;
    }

    public long getBaselineOffset() {
        long result = 0L;
        if (this.behavior != null) {
            result = this.behavior.adjustBaseline(result);
        }
        return result;
    }

    private Extent getContentExtent() {
        return new Extent(this.contentExtent);
    }

    public Extent getExtent() {
        Extent result = this.getContentExtent();
        this.adjustExtent(result);
        return result;
    }

    public final int getHighlightType() {
        return this.highlightType;
    }

    public FLOPoint getLocation() {
        return new FLOPoint(this.location);
    }

    public void initializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        long[] units = composeInfo.getUnitsForProperties(properties);
        AreaDimensionProperty dim = properties.getAreaDimensionProperty();
        if (!dim.isAutoInlineProgressionDimension()) {
            CSSLength ipdFixed = dim.getInlineProgressionDimension();
            this.isIPDFixed = true;
            this.contentExtent.ipd = ipdFixed.getNormalizedLength(units);
        }
        if (!dim.isAutoBlockProgressionDimension()) {
            CSSLength bpdFixed = dim.getBlockProgressionDimension();
            this.isBPDFixed = true;
            this.contentExtent.bpd = bpdFixed.getNormalizedLength(units);
        }
        MarginProperty margin = properties.getMarginProperty();
        SpaceCDT space = margin.getSpaceBefore();
        this.beforeSpace = space.getNormalizedSpace(units);
        space = margin.getSpaceAfter();
        this.afterSpace = space.getNormalizedSpace(units);
        space = margin.getSpaceStart();
        this.startSpace = space.getNormalizedSpace(units);
        space = margin.getSpaceEnd();
        this.endSpace = space.getNormalizedSpace(units);
        if (this.behavior != null) {
            this.behavior.initializeTraits(composeInfo, properties);
        }
    }

    protected boolean isHitPoint(Context context, Transform tf, CSSPoint point) {
        FLOPoint relLocation = this.getLocation();
        Extent relSize = this.getExtent();
        CSSPoint allocationLocation = new CSSPoint(relLocation.start, relLocation.before);
        CSSExtent allocationExtent = new CSSExtent(relSize.ipd, relSize.bpd);
        tf.transformRectangle(allocationLocation, allocationExtent);
        return allocationLocation.x <= point.x && allocationLocation.y <= point.y && point.x < allocationLocation.x + allocationExtent.width && point.y < allocationLocation.y + allocationExtent.height;
    }

    protected void paint(Context context, Transform tf) {
        if (this.behavior != null) {
            FLOPoint relLocation = this.getLocation();
            Extent relSize = this.getExtent();
            CSSPoint allocationLocation = new CSSPoint(relLocation.start, relLocation.before);
            CSSExtent allocationExtent = new CSSExtent(relSize.ipd, relSize.bpd);
            tf.transformRectangle(allocationLocation, allocationExtent);
            this.behavior.paint(context, allocationLocation, allocationExtent);
            if (this.highlightType != 0) {
                CSSColor color = null;
                Border border = null;
                switch (this.highlightType) {
                    case 1: {
                        color = new CSSColor("blue");
                        border = new Border(color, 2L * context.getUnitsPerPixel(), 4);
                        break;
                    }
                    case 2: {
                        color = new CSSColor("red");
                        border = new Border(color, context.getUnitsPerPixel(), 3);
                        break;
                    }
                }
                context.drawBorder(border, border, border, border, allocationLocation, allocationExtent);
            }
        }
    }

    public void setContentBPD(long bpd) {
        this.contentExtent.bpd = bpd;
    }

    public void setContentIPD(long ipd) {
        this.contentExtent.ipd = ipd;
    }

    public final void setHighlightType(int highlightType) {
        this.highlightType = highlightType;
    }

    public void setLocation(long before, long start) {
        this.location.setLocation(before, start);
    }

    public void setLocation(FLOPoint location) {
        this.setLocation(location.before, location.start);
    }

    public String toString() {
        return "<general-area>" + this.diagnostic() + "</general-area>";
    }

    protected void visitAfter(AreaTreeVisitor v) {
        v.afterGeneralArea(this);
    }

    protected void visitBefore(AreaTreeVisitor v) {
        v.beforeGeneralArea(this);
    }
}

