/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.csstypes.Orientation;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.properties.ColorRelatedProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;

public class GlyphBehavior
extends AreaBehavior {
    private char ch;
    private ExtendedFont font;
    private CSSColor color;
    private long baselineOffset;
    private short orientation;
    private short referenceOrientation = 0;
    private WritingMode writingMode;
    private boolean reversed;
    private long ascent;
    private long descent;
    private long width;
    private long glyphDescent;
    private long horizontalOffset;
    private long verticalOffset;

    public GlyphBehavior(ExtendedFont font, char cp) {
        super("glyph");
        this.ch = cp;
        this.font = font;
        this.ascent = font.getAscent();
        this.descent = font.getDescent();
        this.width = font.getCharacterWidth(this.ch);
        this.glyphDescent = font.getCharacterDepth(this.ch);
    }

    public String diagnostic() {
        return "<ch>" + this.ch + "</ch>" + "<orientation>" + Orientation.getName(this.orientation) + "</orientation>" + "<reversed>" + this.reversed + "</reversed>" + "<baseline-offset>" + this.baselineOffset + "</baseline-offset>" + "<vertical-offset>" + this.verticalOffset + "</vertical-offset>" + "<horizontal-offset>" + this.horizontalOffset + "</horizontal-offset>" + "<ascent>" + this.ascent + "</ascent>" + "<descent>" + this.descent + "</descent>" + "<width>" + this.width + "</width>" + "<glyph-descent>" + this.glyphDescent + "</glyph-descent>";
    }

    public void doAdjustAvailable(Extent extent) {
        if (!Orientation.isVertical(this.orientation)) {
            extent.invert();
        }
    }

    protected long doAdjustBaseline(long cur) {
        return cur + this.baselineOffset;
    }

    public void doAdjustExtent(Extent extent) {
        extent.setExtent(this.ascent + this.descent, this.width);
        if (!Orientation.isVertical(this.orientation)) {
            extent.invert();
        }
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        ColorRelatedProperty cp = properties.getColorRelatedProperty();
        this.color = cp.getColor();
        this.referenceOrientation = composeInfo.getReferenceOrientation();
        this.writingMode = composeInfo.getWritingMode();
        WritingModeRelatedProperty wmp = properties.getWritingModeRelatedProperty();
        if (this.writingMode == null) {
            wmp.setDefaults();
            this.writingMode = wmp.getWritingMode();
        }
        short ipd = this.writingMode.getInlineProgressionDirection();
        short bpd = this.writingMode.getBlockProgressionDirection();
        if (ipd == 1) {
            this.orientation = Orientation.rotate((short)3, wmp.getGlyphOrientationVertical(this.ch));
        } else if (ipd == 3) {
            this.orientation = Orientation.rotate((short)1, wmp.getGlyphOrientationVertical(this.ch));
        } else if (bpd == 3) {
            this.orientation = Orientation.rotate((short)2, wmp.getGlyphOrientationHorizontal());
        } else if (bpd == 1) {
            this.orientation = Orientation.rotate((short)0, wmp.getGlyphOrientationHorizontal());
        } else {
            this.orientation = 0;
            throw new IllegalArgumentException("WritingMode inline progression  direction is undefined " + this.writingMode);
        }
        this.reversed = ipd == 1 && bpd == 0 || ipd == 2 && bpd == 1 || ipd == 3 && bpd == 2 || ipd == 0 && bpd == 3;
        this.reorient((short)0);
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        CSSPoint renderLocation = null;
        context.setTextColor(this.color);
        context.setFont(this.font);
        if (this.referenceOrientation != 0) {
            renderLocation = this.referenceOrientation == 90 ? new CSSPoint(location.x + this.ascent, location.y + this.width) : (this.referenceOrientation == 180 ? new CSSPoint(location.x + this.width, location.y + this.descent) : new CSSPoint(location.x + this.descent, location.y));
            context.drawOrientatedGlyph(this.ch, renderLocation, this.referenceOrientation);
        } else {
            renderLocation = new CSSPoint(location.x, location.y + this.ascent);
            context.drawGlyph(this.ch, renderLocation);
        }
    }

    public void reorient(short adjust) {
        this.orientation = Orientation.rotate(this.orientation, adjust);
        if (this.orientation == 0) {
            this.verticalOffset = this.baselineOffset = this.ascent;
            this.horizontalOffset = this.reversed ? this.width : 0L;
        } else if (this.orientation == 2) {
            this.baselineOffset = this.descent;
            this.verticalOffset = this.ascent + this.descent + this.baselineOffset - this.glyphDescent;
            this.horizontalOffset = this.reversed ? 0L : this.width;
        } else if (this.orientation == 3) {
            this.baselineOffset = this.width / 2L;
            this.horizontalOffset = this.reversed ? this.ascent : this.descent;
            this.verticalOffset = 0L;
        } else if (this.orientation == 1) {
            this.baselineOffset = this.width / 2L;
            this.verticalOffset = this.reversed ? this.width : 0L;
            this.horizontalOffset = this.ascent;
        }
    }
}

