/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.Orientation;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Transform;
import com.ibm.xsl.composer.properties.LayoutRelatedProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;

public class ReferenceBehavior
extends AreaBehavior {
    protected WritingMode writingMode = new WritingMode();
    protected short referenceOrientation;

    public ReferenceBehavior() {
        super("reference");
    }

    public String diagnostic() {
        return "<reference>" + this.writingMode + Orientation.getName(this.referenceOrientation) + "</reference>";
    }

    protected void doAdjustTransform(Transform tf, Extent content, FLOPoint location) {
        tf.setReferenceOrientation(this.referenceOrientation, content, location);
        tf.setWritingMode(this.writingMode, content);
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        WritingModeRelatedProperty wm = properties.getWritingModeRelatedProperty();
        this.writingMode = wm.getWritingMode();
        LayoutRelatedProperty lrp = properties.getLayoutRelatedProperty();
        this.referenceOrientation = lrp.getReferenceOrientation();
        WritingMode ctxtWM = composeInfo.getWritingMode();
        if (ctxtWM != null && this.writingMode.getInlineProgressionDirection() == 0 && this.writingMode.getBlockProgressionDirection() == 1) {
            this.writingMode = ctxtWM;
        }
        composeInfo.setWritingMode(this.writingMode);
    }
}

