/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Border;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.ColorRelatedProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.LeaderAndRuleProperty;
import com.ibm.xsl.composer.properties.PropertyMap;

public class RuleBehavior
extends AreaBehavior {
    private Border lineDefinition = new Border();
    private long descent = 0L;

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        BorderPaddingBackgroundProperty bp = properties.getBorderPaddingBackgroundProperty();
        LeaderAndRuleProperty larp = properties.getLeaderAndRuleProperty();
        FontProperty fp = properties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        long[] units = composeInfo.getUnitsForProperties(properties);
        this.lineDefinition.width = larp.getRuleThickness().getNormalizedLength(units);
        this.lineDefinition.style = larp.getRuleStyle();
        ColorRelatedProperty cp = properties.getColorRelatedProperty();
        this.lineDefinition.color = cp.getColor();
        this.descent = font.getDescent();
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        CSSPoint p1 = new CSSPoint(location.x, location.y);
        CSSPoint p2 = new CSSPoint(location.x + extent.width, location.y);
        context.drawRule(p1, p2, this.lineDefinition);
    }

    public String toString() {
        return "[RuleBehavior ]";
    }
}

