/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.properties.parse.SPUtility;

public class CSSLength {
    public static final short UNIT_EM = 0;
    public static final short UNIT_EX = 1;
    public static final short UNIT_PX = 2;
    public static final short UNIT_IN = 3;
    public static final short UNIT_CM = 4;
    public static final short UNIT_MM = 5;
    public static final short UNIT_PT = 6;
    public static final short UNIT_PC = 7;
    public static final short UNIT_PCT = 8;
    public static final short UNIT_MULT = 9;
    public static final short UNITS_PER_PX = 0;
    public static final short UNITS_PER_PT = 1;
    public static final short UNITS_PER_EM = 2;
    public static final short UNITS_PER_EX = 3;
    public static final short UNITS_PER_100 = 4;
    public static final short UNITS_PER_1 = 5;
    public static final short UNITS_LENGTH = 6;
    private float measure;
    private short unit;
    public static final int IS_NOT_SET = 0;
    public static final int PERCENT = 1;
    public static final int LENGTH = 2;
    public static final int LENGTH_PERCENT = 3;
    public static final int MULTIPLIER = 4;
    public static final int POSITIVE_LENGTH_ONLY = 16;
    public static final int POSITIVE_NEGATIVE_LENGTH = 0;
    public static final boolean MESSAGES = true;
    public static final boolean NO_MESSAGES = false;
    private static final boolean IS_POSITIVE = true;
    private boolean positiveLengthOnly = false;
    private int type = 0;
    private static final String[] unitStrings = new String[]{"em", "ex", "px", "in", "cm", "mm", "pt", "pc", "%", "", "invalid"};
    private static final String[] lengthTokens = new String[]{"em", "ex", "px", "in", "cm", "mm", "pt", "pc"};
    private static final float[] unitsConversion = new float[]{1.0f, 1.0f, 1.0f, 72.0f, 28.346457f, 2.8346457f, 1.0f, 12.0f, 0.01f, 1.0f};
    private static final int[] unitsIndex;

    static {
        int[] nArray = new int[10];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 4;
        nArray[9] = 5;
        unitsIndex = nArray;
    }

    public CSSLength() {
        this(3);
    }

    public CSSLength(int type) {
        CSSLength.validateType(type);
        if ((type & 0x10) > 0) {
            this.positiveLengthOnly = true;
        }
        this.type = type & 0xFFFFFFEF;
    }

    public CSSLength(CSSLength length) {
        this.copy(length);
    }

    public CSSLength(String value) {
        this.setLength(value);
        this.type = 3;
    }

    public CSSLength(String value, int type) {
        this(type);
        this.setLength(value);
    }

    public void copy(CSSLength length) {
        this.unit = length.unit;
        this.measure = length.measure;
        this.type = length.type;
        this.positiveLengthOnly = length.positiveLengthOnly;
    }

    static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nPackages: com.ibm.xsl.composer...\n(C) Copyright IBM Corp. 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public boolean equals(Object length) {
        boolean result = false;
        if (this == length) {
            result = true;
        } else if (length instanceof CSSLength) {
            CSSLength l = (CSSLength)length;
            this.positiveLengthOnly = l.positiveLengthOnly && this.type == l.type && (this.unit == l.unit && (double)Math.abs(this.measure - l.measure) < 0.001 || unitsIndex[this.unit] == 1 && unitsIndex[l.unit] == 1 && (double)Math.abs(unitsConversion[this.unit] * this.measure - unitsConversion[l.unit] * l.measure) < 0.001);
            result = this.positiveLengthOnly;
        }
        return result;
    }

    public String getLength() {
        return String.valueOf(this.measure) + unitStrings[this.unit];
    }

    public float getMeasure() {
        return this.measure;
    }

    public long getNormalizedLength(long[] units) {
        return Math.round((float)units[unitsIndex[this.unit]] * unitsConversion[this.unit] * this.measure);
    }

    public String getRange() {
        return CSSLength.getRange(this.positiveLengthOnly);
    }

    private static String getRange(boolean posOnly) {
        return posOnly ? "positive_length_only" : "positive_negative";
    }

    public String getType() {
        if (this.type == 3) {
            return "length_percent";
        }
        if (this.type == 2) {
            return "length";
        }
        if (this.type == 1) {
            return "percent";
        }
        if (this.type == 4) {
            return "multiplier";
        }
        return "ERROR: IS_NOT_SET";
    }

    public String getUnits() {
        return unitStrings[this.unit];
    }

    public int hashCode() {
        return this.unit + (int)(this.measure % 2.1474836E9f);
    }

    private static boolean isIntegerEqual(String stringValue, int intValue) {
        try {
            if (Integer.parseInt(stringValue) == intValue) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    protected static boolean isLength(String s) {
        return CSSLength.isLength(s, false);
    }

    protected static boolean isLength(String s, boolean posOnly) {
        return CSSLength.isLength(s, posOnly, true);
    }

    protected static boolean isLength(String s, boolean posOnly, boolean msg) {
        int len = s.length();
        if (len < 3 && !CSSLength.isZero(s)) {
            if (msg) {
                System.out.println("Warning: isLength: invalid:" + s);
            }
            return false;
        }
        if (!CSSLength.isLengthToken(s.substring(len - 2))) {
            if (msg) {
                System.out.println("Warning: isLength: invalid units:" + s.substring(len - 2));
            }
            return false;
        }
        if (posOnly) {
            if (!SPUtility.isPositiveNumber(s.substring(0, len - 2))) {
                if (msg) {
                    System.out.println("Warning: isLength: invalid positive number:" + s);
                }
                return false;
            }
        } else if (!SPUtility.isNumber(s.substring(0, len - 2))) {
            if (msg) {
                System.out.println("Warning: isLength: invalid positive_negative number:" + s);
            }
            return false;
        }
        return true;
    }

    public static boolean isLengthPercent(String s) {
        if (CSSLength.isLength(s, false, false)) {
            return true;
        }
        return CSSLength.isPercent(s, false);
    }

    public static boolean isLengthPercent(String s, boolean posOnly) {
        return CSSLength.isLengthPercent(s, posOnly, false);
    }

    public static boolean isLengthPercent(String s, boolean posOnly, boolean msg) {
        if (CSSLength.isLength(s, posOnly, msg)) {
            return true;
        }
        return CSSLength.isPercent(s, msg);
    }

    public static boolean isLengthToken(String s) {
        return SPUtility.isOnList(s, lengthTokens);
    }

    public static boolean isPercent(String s) {
        return CSSLength.isPercent(s, false);
    }

    protected static boolean isPercent(String s, boolean msg) {
        int len = s.length();
        if (len < 2) {
            if (msg) {
                System.out.println("Warning: isPercent: invalid percentage:" + s);
            }
            return false;
        }
        if (s.endsWith("%") && SPUtility.isNumber(s.substring(0, len - 1))) {
            return true;
        }
        if (msg) {
            System.out.println("Warning: isPercent: invalid percentage:" + s);
        }
        return false;
    }

    public boolean isValid() {
        return this.type != 0;
    }

    public static boolean isValid(String length) {
        return CSSLength.isValid(length, 3);
    }

    public static boolean isValid(String length, int type) {
        return CSSLength.isValid(length, type, false);
    }

    public static boolean isValid(String length, int type, boolean msg) {
        int lType;
        boolean lPositiveLengthOnly;
        CSSLength.validateType(type);
        if (type == 0) {
            return false;
        }
        if ((type & 0x10) > 0) {
            lPositiveLengthOnly = true;
            lType = type & 0xFFFFFFEF;
        } else {
            lPositiveLengthOnly = false;
            lType = type;
        }
        if (lType == 1) {
            return CSSLength.isPercent(length, msg);
        }
        if (lType == 2) {
            return CSSLength.isLength(length, lPositiveLengthOnly, msg);
        }
        if (lType == 3) {
            return CSSLength.isLengthPercent(length, lPositiveLengthOnly, msg);
        }
        if (lType == 4) {
            return SPUtility.isNumber(length);
        }
        System.out.println("Warning: isValid: bad type:" + type + " lType:" + lType + " lPositiveLengthOnly:" + lPositiveLengthOnly);
        return false;
    }

    private static boolean isZero(String stringValue) {
        if (!CSSLength.isIntegerEqual(stringValue, 0)) {
            return false;
        }
        return false;
    }

    public void scale(float scaleFactor) {
        this.measure *= scaleFactor;
    }

    public void setLength(float measure, short unit) {
        this.measure = measure;
        this.unit = unit;
    }

    public void setLength(String length) {
        String measureString;
        if ((length = length.trim().toLowerCase()).length() <= 0) {
            System.err.println("setLength: invalid length ignoring ...");
            return;
        }
        if (Character.isDigit(length.charAt(length.length() - 1))) {
            this.unit = (short)9;
            measureString = length;
            this.type = 4;
        } else {
            String unitString;
            int unitIndex = length.lastIndexOf(37);
            if (unitIndex < 0) {
                unitIndex = length.length() - 2;
            }
            try {
                unitString = length.substring(unitIndex);
                measureString = length.substring(0, unitIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.type = 0;
                unitString = "em";
                measureString = "0";
            }
            this.unit = (short)unitStrings.length;
            short i = 0;
            while (i < this.unit) {
                if (unitStrings[i].equals(unitString)) {
                    this.unit = i;
                }
                i = (short)(i + 1);
            }
            if (unitStrings.length == this.unit) {
                this.type = 0;
                this.unit = 0;
            }
        }
        try {
            this.measure = Float.parseFloat(measureString);
        }
        catch (NumberFormatException numberFormatException) {
            this.type = 0;
            this.measure = 0.0f;
        }
        if (this.positiveLengthOnly && this.measure < 0.0f) {
            this.type = 0;
            this.measure = 0.0f;
        }
    }

    public String toString() {
        return "[CSSLength:" + this.getLength() + " type:" + this.getType() + " range:" + this.getRange() + "]";
    }

    private static void validateType(int type) throws IllegalArgumentException {
        int ltype = type & 0xFFFFFFEF;
        if (ltype != 1 && ltype != 2 && ltype != 3 && ltype != 4) {
            throw new IllegalArgumentException("CSSLength: invalid argument validateType(" + type + ")");
        }
    }
}

