/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPUtility;

public class FontSize {
    public static final short INHERIT_BY_COPYING = 0;
    public static final short INHERIT_NOTHING = 1;
    public static final short INHERIT_LARGER = 2;
    public static final short INHERIT_SMALLER = 3;
    public static final short XX_SMALL_SIZE = 4;
    public static final short X_SMALL_SIZE = 8;
    public static final short SMALL_SIZE = 10;
    public static final short MEDIUM_SIZE = 12;
    public static final short LARGE_SIZE = 30;
    public static final short X_LARGE_SIZE = 50;
    public static final short XX_LARGE_SIZE = 100;
    public int inheritFontSize = 0;
    public final CSSLength fontSize = new CSSLength("12pt");
    public static final short FONT_SIZE_ADJUST_INHERIT = 0;
    public static final short FONT_SIZE_ADJUST_NONE = 1;
    public static final short FONT_SIZE_ADJUST_VALUE = 2;
    private static final ShortMap fontSizeAdjustMap = new ShortMap(new String[]{"inherit", "none"});
    public short fontSizeAdjustValue = 0;
    public Float fontSizeAdjust;
    private static final String[] names = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    private static final short[] codeValue = new short[]{4, 8, 10, 12, 30, 50, 100};
    private static final ShortMap fontSizeMap = new ShortMap(names, codeValue);

    public static final short decodeName(String name) {
        return fontSizeMap.decodeName(name);
    }

    public CSSLength getFontSize() {
        return this.fontSize;
    }

    public int getFontSizeAdjust() {
        return this.fontSizeAdjust.intValue();
    }

    public String getFontSizeAdjustAttribute() {
        return String.valueOf(this.fontSizeAdjust);
    }

    public String getFontSizeAttribute() {
        return String.valueOf(this.fontSize);
    }

    public static final String getFontSizeName(short value) {
        return fontSizeMap.getName(value);
    }

    public void setFontSize(int size) {
        this.fontSize.setLength(String.valueOf(String.valueOf(size)) + "pt");
        this.inheritFontSize = 0;
    }

    public void setFontSize(String size) throws ParseException {
        if ((size = size.toLowerCase()).equals("inherit")) {
            this.inheritFontSize = 0;
        } else if (SPUtility.isAbsoluteSize(size)) {
            this.inheritFontSize = 1;
            short iSize = fontSizeMap.decodeName(size);
            this.fontSize.setLength(String.valueOf(String.valueOf(iSize)) + "pt");
        } else if (SPUtility.isRelativeSize(size)) {
            this.inheritFontSize = size.equals("larger") ? 2 : 3;
        } else if (CSSLength.isValid(size, 19)) {
            this.fontSize.setLength(size);
            this.inheritFontSize = 1;
        } else {
            new ParseBase().dontUnderstand("font-size", size);
        }
    }

    public void setFontSizeAdjust(String size) {
        try {
            this.fontSizeAdjustValue = fontSizeAdjustMap.decodeName(size);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (SPUtility.isNumber(size)) {
                this.fontSizeAdjust = new Float(size);
                this.fontSizeAdjustValue = (short)2;
            }
            new ParseBase().dontUnderstand("font-size-adjust", size);
        }
    }
}

