/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.LengthRange;

public class IpdBpdCDT {
    private LengthRange mmo = new LengthRange(19);
    private boolean inherit = false;
    private boolean minimumIsAuto = true;
    private boolean optimumIsAuto = true;
    private boolean maximumIsAuto = true;
    private static final String INHERIT = "inherit";
    private static final String AUTO = "auto";

    public void copy(IpdBpdCDT p) {
        this.mmo.copy(p.mmo);
        this.inherit = p.inherit;
        this.minimumIsAuto = p.minimumIsAuto;
        this.optimumIsAuto = p.optimumIsAuto;
        this.maximumIsAuto = p.maximumIsAuto;
    }

    public CSSLength getMaximum() {
        return this.mmo.getMaximum();
    }

    public CSSLength getMinimum() {
        return this.mmo.getMinimum();
    }

    public CSSLength getOptimum() {
        return this.mmo.getOptimum();
    }

    public String getString() {
        return this.inherit ? INHERIT : "minimum:" + (this.minimumIsAuto ? AUTO : this.mmo.getMinimumString()) + " optimum:" + (this.optimumIsAuto ? AUTO : this.mmo.getOptimumString()) + " maximum:" + (this.maximumIsAuto ? AUTO : this.mmo.getMaximumString());
    }

    public boolean isInherited() {
        return this.inherit;
    }

    public boolean isMaximumAuto() {
        return this.maximumIsAuto;
    }

    public boolean isMinimumAuto() {
        return this.minimumIsAuto;
    }

    public boolean isOptimumAuto() {
        return this.optimumIsAuto;
    }

    private void setAutoAll() {
        this.minimumIsAuto = true;
        this.optimumIsAuto = true;
        this.maximumIsAuto = true;
    }

    private void setAutoNone() {
        this.minimumIsAuto = false;
        this.optimumIsAuto = false;
        this.maximumIsAuto = false;
    }

    public void setLength(String s) {
        if ((s = s.trim().toLowerCase()).equals(INHERIT)) {
            this.setAutoNone();
            this.inherit = true;
        } else if (s.equals(AUTO)) {
            this.setAutoAll();
            this.inherit = false;
        } else {
            this.setAutoNone();
            this.mmo.setLength(s);
            this.inherit = false;
        }
    }

    public void setMaximum(String s) {
        if ((s = s.trim().toLowerCase()).equals(AUTO)) {
            this.maximumIsAuto = true;
        } else {
            this.maximumIsAuto = false;
            this.mmo.setMaximum(s);
        }
        this.inherit = false;
    }

    public void setMaximumAuto(boolean auto) {
        this.maximumIsAuto = auto;
        this.inherit = false;
    }

    public void setMinimum(String s) {
        if ((s = s.trim().toLowerCase()).equals(AUTO)) {
            this.minimumIsAuto = true;
        } else {
            this.minimumIsAuto = false;
            this.mmo.setMinimum(s);
        }
        this.inherit = false;
    }

    public void setMinimumAuto(boolean auto) {
        this.minimumIsAuto = auto;
        this.inherit = false;
    }

    public void setOptimum(String s) {
        if ((s = s.trim().toLowerCase()).equals(AUTO)) {
            this.optimumIsAuto = true;
        } else {
            this.optimumIsAuto = false;
            this.mmo.setOptimum(s);
        }
        this.inherit = false;
    }

    public void setOptimumAuto(boolean auto) {
        this.optimumIsAuto = auto;
        this.inherit = false;
    }
}

