/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.csstypes.CSSLength;
import java.util.Hashtable;

public class LengthPlus
extends CSSLength {
    private Hashtable allowed = new Hashtable();
    private String theValue = "";

    public LengthPlus() {
    }

    public LengthPlus(String[] allowedList) {
        this(allowedList, "0pt");
    }

    public LengthPlus(String[] allowedList, String defaultValue) {
        this(allowedList, defaultValue, 3);
    }

    public LengthPlus(String[] allowedList, String defaultValue, int type) {
        super(type);
        this.setAllowedList(allowedList);
        this.setLength(defaultValue);
    }

    public void copy(LengthPlus length) {
        this.theValue = new String(length.theValue);
        this.allowed = new Hashtable(length.allowed);
        super.copy(length);
    }

    public boolean equals(Object length) {
        if (length instanceof LengthPlus) {
            LengthPlus object = (LengthPlus)length;
            if (this.theValue.equals(object.theValue)) {
                return true;
            }
        }
        return super.equals(length);
    }

    public String getLength() {
        if (this.allowed.containsKey(this.theValue)) {
            return this.theValue;
        }
        return super.getLength();
    }

    public int hashCode() {
        if (this.allowed.containsKey(this.theValue)) {
            return this.theValue.hashCode();
        }
        return super.hashCode();
    }

    public boolean isLPValid(String theValue, int type) {
        if (this.allowed.containsKey(theValue)) {
            return true;
        }
        return CSSLength.isValid(theValue, type);
    }

    protected void setAllowedList(String[] list) {
        if (list == null) {
            System.out.println("setAllowedList(null)");
            return;
        }
        int i = 0;
        while (i < list.length) {
            this.allowed.put(list[i], list[i]);
            ++i;
        }
    }

    public void setLength(String length) {
        String value = length.toLowerCase();
        if (this.allowed.containsKey(value)) {
            this.theValue = value;
            return;
        }
        super.setLength(length);
        this.theValue = super.getLength();
    }

    public String toString() {
        String s = "";
        if (this.allowed.containsKey(this.theValue)) {
            return "[LengthPlus:" + this.theValue + "]";
        }
        return "[LengthPlus:" + this.getLength() + " type:" + this.getType() + " range:" + this.getRange() + "]";
    }
}

