/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSAlign;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.flo.InlinePacker;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BlockAndLineRelatedProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.Iterator;
import org.w3c.dom.Node;

public class BlockStacker {
    private ChildNodeWalker walker;
    private SpaceRequest lastChildRequest;
    private Node parentFO;
    private InlinePacker inline = new InlinePacker();
    private boolean haveInitializedInline = false;
    private PropertyMap blockProperties;
    private Extent fitAvailable;

    public void arrangeChildren(ComposeInfo composeInfo, Extent available, SpaceRequest chosenRequest, GeneralArea blockArea) {
        BlockAndLineRelatedProperty balrp = this.blockProperties.getBlockAndLineRelatedProperty();
        CSSAlign align = balrp.getTextAlign();
        SpaceRequest totalHeight = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent childAllocation = new Extent(available);
        Iterator blockRequests = chosenRequest.getChildRequests();
        while (blockRequests.hasNext()) {
            SpaceRequest blockRequest = (SpaceRequest)blockRequests.next();
            FLO blockNode = (FLO)blockRequest.getFormatter();
            childAllocation.setBPD(blockRequest.getOptimum());
            GeneralArea childArea = blockNode.composeAreas(composeInfo, childAllocation, blockRequest);
            Extent areaExtent = childArea.getExtent();
            if (!childArea.isAbsolutePositioned) {
                switch (align.getAlignment()) {
                    case 2: {
                        curPoint.start = (available.ipd - areaExtent.ipd) / 2L;
                        break;
                    }
                    case 0: 
                    case 5: 
                    case 7: {
                        curPoint.start = 0L;
                        break;
                    }
                    case 3: 
                    case 6: {
                        curPoint.start = available.ipd - areaExtent.ipd;
                        break;
                    }
                    case 4: {
                        curPoint.start = 0L;
                        break;
                    }
                    default: {
                        curPoint.start = 0L;
                    }
                }
            }
            curPoint.before += totalHeight.getInterSpace(blockRequest).getOptimum();
            if (!childArea.isAbsolutePositioned) {
                childArea.setLocation(curPoint);
            }
            totalHeight.appendRequest(blockRequest);
            curPoint.before = totalHeight.getAreaOptimum();
        }
    }

    public SpaceAlternatives composeRequestForArea(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest, GeneralArea blockArea) {
        if (priorRequest == null) {
            this.walker = new ChildNodeWalker(this.parentFO);
            this.walker.getNext();
            this.lastChildRequest = null;
        } else {
            if (this.walker == null) {
                this.walker = new ChildNodeWalker(this.parentFO);
            }
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
            this.lastChildRequest = priorRequest.getLastChildRequest();
        }
        SpaceAlternatives alternatives = new SpaceAlternatives();
        alternatives.setFit(2);
        boolean exceeded = false;
        boolean progress = false;
        SpaceRequest totalBPD = new SpaceRequest();
        SpaceRequest returnRequest = new SpaceRequest(this.parentFO, blockArea);
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent remaining = new Extent(available);
        SpaceAlternatives nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
        while (!(nextAlternatives == null || progress && exceeded)) {
            GeneralArea childArea;
            SpaceRequest request;
            int fit = nextAlternatives.getFit();
            if (fit == 0) {
                long consumed;
                progress = true;
                request = nextAlternatives.getFirstBodyRequest();
                totalBPD.appendRequest(request);
                returnRequest.incorporateRequest(request);
                childArea = request.getRequestorArea();
                blockArea.addChild(childArea);
                composeInfo.isPageDirty = true;
                blockArea.extendContentArea(curPoint, childArea.getExtent());
                returnRequest.setCursor(this.walker.getCurrentNode());
                this.lastChildRequest = request;
                curPoint.before = consumed = totalBPD.getOptimum();
                remaining.setBPD(available.bpd - consumed);
                alternatives.setFit(0);
                if (request.getBreakAfter() >= 2) {
                    returnRequest.addBreakAfter(request.getBreakAfter());
                    break;
                }
                nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                continue;
            }
            if (fit == 2) {
                nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                continue;
            }
            if (fit != 1) continue;
            if (!progress) {
                exceeded = true;
                progress = true;
                request = nextAlternatives.getFirstBodyRequest();
                totalBPD.appendRequest(request);
                returnRequest.setCursor(this.walker.getCurrentNode());
                this.lastChildRequest = request;
                returnRequest.incorporateRequest(request);
                childArea = request.getRequestorArea();
                blockArea.addChild(childArea);
                composeInfo.isPageDirty = true;
                blockArea.extendContentArea(curPoint, childArea.getExtent());
                alternatives.setFit(1);
                continue;
            }
            exceeded = true;
        }
        if (!progress) {
            alternatives.setFit(2);
        }
        alternatives.addSpaceRequest(returnRequest);
        return alternatives;
    }

    private SpaceAlternatives generateNextAlternatives(ComposeInfo composeInfo, Extent available) {
        SpaceAlternatives alternatives = null;
        Node nextFO = this.walker.getCurrentNode();
        while (nextFO != null) {
            if (nextFO instanceof InlineContent) {
                if (!this.haveInitializedInline) {
                    this.inline.initialize(this.parentFO, nextFO, this.blockProperties);
                    this.haveInitializedInline = true;
                }
                if ((alternatives = this.inline.composeRequest(composeInfo, available, this.lastChildRequest)) != null && alternatives.getFit() != 2) break;
                this.haveInitializedInline = false;
                nextFO = this.inline.nextNode();
                this.walker.setCurrentNode(nextFO);
                this.lastChildRequest = null;
                nextFO = this.walker.getCurrentNode();
                continue;
            }
            WritingMode writingModeFromParent = composeInfo.getWritingMode();
            if (writingModeFromParent != null && !writingModeFromParent.isVertical()) {
                available.ipd = composeInfo.getEnclosingBlockIPD();
            }
            this.fitAvailable = new Extent(available);
            alternatives = ((FLO)((Object)nextFO)).composeRequest(composeInfo, available, this.lastChildRequest);
            if (alternatives.getFit() != 2) break;
            nextFO = this.walker.getNext();
            this.lastChildRequest = null;
            if (writingModeFromParent != null && !writingModeFromParent.isVertical()) {
                available = this.fitAvailable;
            }
            nextFO = this.walker.getCurrentNode();
        }
        return alternatives;
    }

    public void initialize(Node parent, PropertyMap blockProperties) {
        this.parentFO = parent;
        this.blockProperties = blockProperties;
        this.reset();
    }

    public void reset() {
        this.haveInitializedInline = false;
    }

    public String toString() {
        return "[blockStacker " + Integer.toHexString(this.hashCode()) + "]";
    }
}

