/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.flo.FLODOMImpl;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLORoot;
import com.ibm.xsl.composer.flo.FLOText;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.EndElementHandler;
import com.ibm.xsl.composer.framework.FLOTreeBuilder;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FLODocument
extends DocumentImpl {
    final PropertyMap defaultProperties = new PropertyMap(null);
    private boolean FLOTextTrailingBlank = false;
    public static final String XSL_FO_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Format";
    public static final String XSL_FO_NAMESPACE_PREFIX = "fo:";
    public static final String XSL_IBM_NAMESPACE_PREFIX = "ibm:";
    public static int K_RECOMPOSED = 0;
    public static int K_ASNECESSARY = 1;
    public static int K_MUSTREFLOW = 2;
    public static int K_MUSTRECOMPOSEFULLY = 3;
    private int compositionStatus = K_MUSTRECOMPOSEFULLY;
    private static final Hashtable elementTable = new Hashtable();
    private static Class[] elementConstructorSignature;
    private FLOTreeBuilder treeBuilder;
    static /* synthetic */ Class class$org$apache$xerces$dom$DocumentImpl;
    static /* synthetic */ Class class$java$lang$String;

    static {
        elementTable.put("root", "com.ibm.xsl.composer.flo.FLORoot");
        elementTable.put("character", "com.ibm.xsl.composer.flo.FLOCharacter");
        elementTable.put("block", "com.ibm.xsl.composer.flo.FLOBlock");
        elementTable.put("button", "com.ibm.xsl.composer.flo.FLOButton");
        elementTable.put("input", "com.ibm.xsl.composer.flo.FLOInput");
        elementTable.put("declarations", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("color-profile", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("page-sequence", "com.ibm.xsl.composer.flo.FLOPageSequence");
        elementTable.put("layout-master-set", "com.ibm.xsl.composer.flo.FLOLayoutMasterSet");
        elementTable.put("page-sequence-master", "com.ibm.xsl.composer.flo.FLOPageSequenceMaster");
        elementTable.put("single-page-master-reference", "com.ibm.xsl.composer.flo.FLOSinglePageMasterReference");
        elementTable.put("repeatable-page-master-reference", "com.ibm.xsl.composer.flo.FLORepeatablePageMasterReference");
        elementTable.put("repeatable-page-master-alternatives", "com.ibm.xsl.composer.flo.FLORepeatablePageMasterAlternatives");
        elementTable.put("conditional-page-master-reference", "com.ibm.xsl.composer.flo.FLOConditionalPageMasterReference");
        elementTable.put("simple-page-master", "com.ibm.xsl.composer.flo.FLOSimplePageMaster");
        elementTable.put("region-body", "com.ibm.xsl.composer.flo.FLORegion");
        elementTable.put("region-before", "com.ibm.xsl.composer.flo.FLORegion");
        elementTable.put("region-after", "com.ibm.xsl.composer.flo.FLORegion");
        elementTable.put("region-start", "com.ibm.xsl.composer.flo.FLORegion");
        elementTable.put("region-end", "com.ibm.xsl.composer.flo.FLORegion");
        elementTable.put("flow", "com.ibm.xsl.composer.flo.FLOFlow");
        elementTable.put("static-content", "com.ibm.xsl.composer.flo.FLOStaticContent");
        elementTable.put("title", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("block-container", "com.ibm.xsl.composer.flo.FLOBlockContainer");
        elementTable.put("bidi-override", "com.ibm.xsl.composer.flo.FLOContentCannotBeRendered");
        elementTable.put("initial-property-set", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("external-graphic", "com.ibm.xsl.composer.flo.FLOExternalGraphic");
        elementTable.put("instream-foreign-object", "com.ibm.xsl.composer.flo.FLOContentCannotBeRendered");
        elementTable.put("inline", "com.ibm.xsl.composer.flo.FLOInline");
        elementTable.put("inline-container", "com.ibm.xsl.composer.flo.FLOContentCannotBeRendered");
        elementTable.put("leader", "com.ibm.xsl.composer.flo.FLOLeader");
        elementTable.put("page-number", "com.ibm.xsl.composer.flo.FLOPageNumber");
        elementTable.put("page-number-citation", "com.ibm.xsl.composer.flo.FLOContentCannotBeRendered");
        elementTable.put("table", "com.ibm.xsl.composer.flo.table.FLOTable");
        elementTable.put("table-and-caption", "com.ibm.xsl.composer.flo.table.FLOTableAndCaption");
        elementTable.put("table-column-group", "com.ibm.xsl.composer.flo.table.FLOTableColumnGroup");
        elementTable.put("table-column", "com.ibm.xsl.composer.flo.table.FLOTableColumn");
        elementTable.put("table-caption", "com.ibm.xsl.composer.flo.table.FLOTableCaption");
        elementTable.put("table-header", "com.ibm.xsl.composer.flo.table.FLOTableRowGroup");
        elementTable.put("table-footer", "com.ibm.xsl.composer.flo.table.FLOTableRowGroup");
        elementTable.put("table-body", "com.ibm.xsl.composer.flo.table.FLOTableRowGroup");
        elementTable.put("table-row", "com.ibm.xsl.composer.flo.table.FLOTableRow");
        elementTable.put("table-cell", "com.ibm.xsl.composer.flo.table.FLOTableCell");
        elementTable.put("list-block", "com.ibm.xsl.composer.flo.FLOListBlock");
        elementTable.put("list-item", "com.ibm.xsl.composer.flo.FLOListItem");
        elementTable.put("list-item-body", "com.ibm.xsl.composer.flo.FLOListItemBody");
        elementTable.put("list-item-label", "com.ibm.xsl.composer.flo.FLOListItemLabel");
        elementTable.put("simple-link", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("multi-switch", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("multi-case", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("multi-toggle", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("multi-properties", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("multi-property-set", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("float", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("footnote", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("footnote-body", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("wrapper", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("marker", "com.ibm.xsl.composer.flo.FLOWrapper");
        elementTable.put("retrieve-marker", "com.ibm.xsl.composer.flo.FLOContentCannotBeRendered");
        elementConstructorSignature = new Class[]{class$org$apache$xerces$dom$DocumentImpl != null ? class$org$apache$xerces$dom$DocumentImpl : (class$org$apache$xerces$dom$DocumentImpl = FLODocument.class$("org.apache.xerces.dom.DocumentImpl")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FLODocument.class$("java.lang.String"))};
    }

    public FLODocument() {
    }

    protected FLODocument(DocumentType doctype) {
        super(doctype);
    }

    public void addEndElementHandler(String eltName, EndElementHandler eh) {
        this.treeBuilder.addEndElementHandler(eltName, eh);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public AreaTree composeDocument(Context context) throws DOMException {
        AreaTree tree = null;
        this.compositionStatus = K_RECOMPOSED;
        FLORoot root = null;
        try {
            root = (FLORoot)((Object)this.getDocumentElement());
        }
        catch (ClassCastException classCastException) {
            root = null;
        }
        if (root == null) {
            throw new DOMException(8, "Document does not start with fo:root");
        }
        root.reset();
        root.propogateAttributes(this.defaultProperties);
        tree = root.composeDocument(context);
        return tree;
    }

    public static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nPackages: com.ibm.xsl.composer...\n(C) Copyright IBM Corp. 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return super.createCDATASection(data);
    }

    public Element createElement(String tagName) throws DOMException {
        Object el = null;
        if (tagName.startsWith(XSL_FO_NAMESPACE_PREFIX)) {
            el = this.createFLOElementForName(tagName.substring(XSL_FO_NAMESPACE_PREFIX.length()));
        } else if (tagName.startsWith(XSL_IBM_NAMESPACE_PREFIX)) {
            el = this.createFLOElementForName(tagName.substring(XSL_IBM_NAMESPACE_PREFIX.length()));
        }
        if (el == null) {
            el = super.createElement(tagName);
        }
        return el;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        Object el = null;
        if (namespaceURI.equals(XSL_FO_NAMESPACE_URI)) {
            el = this.createFLOElementForName(qualifiedName);
        }
        if (el == null) {
            el = super.createElementNS(namespaceURI, qualifiedName);
        }
        return el;
    }

    private FLOElement createFLOElementForName(String qualifiedName) {
        FLOElement result = null;
        String className = (String)elementTable.get(FLODocument.stripQualifier(qualifiedName));
        if (className != null) {
            try {
                Class<?> elemClass = Class.forName(className);
                Constructor<?> elemConst = elemClass.getConstructor(elementConstructorSignature);
                Object[] elementConstructorArgs = new Object[]{this, qualifiedName};
                result = (FLOElement)elemConst.newInstance(elementConstructorArgs);
                this.FLOTextTrailingBlank = false;
            }
            catch (Exception ex) {
                System.err.println("Failed to create element, '" + qualifiedName + ".'");
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (result == null) {
            throw new DOMException(14, "Failed to create element " + qualifiedName + " for fo namespace.");
        }
        return result;
    }

    public Text createTextNode(String data) {
        FLOText result = new FLOText(this, data, this, null);
        return result;
    }

    public Text createTextNode(String data, Node parent) {
        FLOText result = new FLOText(this, data, this, parent);
        return result;
    }

    public int getCompositionStatus() {
        return this.compositionStatus;
    }

    public boolean getFLOTextTrailingBlank() {
        return this.FLOTextTrailingBlank;
    }

    public DOMImplementation getImplementation() {
        return FLODOMImpl.getDOMImplementation();
    }

    public FLOTreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public void removeEndElementHandler(String eltName) {
        this.treeBuilder.removeEndElementHandler(eltName);
    }

    public void setCompositionStatus(int kCompositionStatus) {
        this.compositionStatus = kCompositionStatus;
    }

    public void setFLOTextTrailingBlank(boolean trailingblank) {
        this.FLOTextTrailingBlank = trailingblank;
    }

    public void setTreeBuilder(FLOTreeBuilder treeBuilder) {
        if (this.treeBuilder != null) {
            throw new IllegalStateException();
        }
        this.treeBuilder = treeBuilder;
    }

    public static String stripQualifier(String qualifiedName) {
        int colonIndex = qualifiedName.indexOf(58);
        String localName = colonIndex >= 0 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
        return localName;
    }
}

