/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.GraphBehavior;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.MiscellaneousProperty;
import java.net.URL;
import org.apache.xerces.dom.DocumentImpl;

public class FLOExternalGraphic
extends FLOFormattable
implements InlineContent {
    public FLOExternalGraphic(DocumentImpl dom) {
        this(dom, "external-graphic");
    }

    public FLOExternalGraphic(DocumentImpl dom, String elementName) {
        super(dom, elementName);
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        bp.setDefaults();
    }

    protected void addBehaviorsForArea(GeneralArea area, ComposeInfo composeInfo) {
        MiscellaneousProperty miscProperty = this.properties.getMiscellaneousProperty();
        URL source = miscProperty.getSrc();
        String uri = source.toExternalForm();
        this.addStandardBorderAndBackgroundBehavior(area);
        GraphBehavior graph = new GraphBehavior(composeInfo.context, uri);
        area.addBehavior(graph);
        area.extendContentArea(new FLOPoint(), graph.getExtent());
    }

    protected GeneralArea createArea(ComposeInfo composeInfo, Extent available) {
        GeneralArea area = new GeneralArea();
        return area;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        Extent graphExtent = request.getRequestorArea().getExtent();
        request.setAreaOptimum(graphExtent.ipd);
        return this.fitOrNoFit(available.doesFit(graphExtent));
    }

    public String toString() {
        return "[fo:external-graphic]";
    }
}

