/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.FLOListItem;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.MiscellaneousProperty;
import java.util.Iterator;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOListBlock
extends FLOFormattable
implements BlockContent {
    private ChildNodeWalker walker;
    private boolean isInitialized;
    private CSSLength startSepLen;
    private long startSep;
    private CSSLength labelSepLen;
    private long labelSep;
    private SpaceRequest lastChildRequest;

    public FLOListBlock(DocumentImpl ownerDocument) {
        this(ownerDocument, "list-block");
    }

    public FLOListBlock(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        this.setLengths(composeInfo);
        GeneralArea areaSubtree = chosenRequest.getRequestorArea();
        SpaceRequest totalHeight = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent childAllocation = new Extent(allocated);
        Iterator listRequests = chosenRequest.getChildRequests();
        while (listRequests.hasNext()) {
            SpaceRequest listRequest = (SpaceRequest)listRequests.next();
            FLOListItem blockNode = (FLOListItem)listRequest.getFormatter();
            childAllocation.setBPD(listRequest.getOptimum());
            GeneralArea childArea = blockNode.composeItemAreas(composeInfo, childAllocation, listRequest, this.startSep - this.labelSep, this.labelSep, allocated.ipd - this.startSep);
            curPoint.before += totalHeight.getInterSpace(listRequest).getOptimum();
            childArea.setLocation(curPoint);
            areaSubtree.addChild(childArea);
            totalHeight.appendRequest(listRequest);
            curPoint.before = totalHeight.getAreaOptimum();
        }
        this.addProgeny(areaSubtree);
        return areaSubtree;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        SpaceAlternatives alternatives = new SpaceAlternatives();
        if (!this.isInitialized) {
            this.initialize();
        }
        this.setLengths(composeInfo);
        if (priorRequest != null) {
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
            this.lastChildRequest = priorRequest.getLastChildRequest();
        } else {
            this.walker = new ChildNodeWalker((Node)((Object)this));
            this.walker.getNext();
            this.skipToAnItemFormatter();
        }
        this.walker.getCurrentNode();
        GeneralArea blockArea = new GeneralArea();
        blockArea.initializeTraits(composeInfo, this.properties);
        blockArea.setProgenitor(this);
        blockArea.adjustAvailable(available);
        SpaceAlternatives bodyAlternatives = this.generateNextAlternatives(composeInfo, available);
        boolean exceeded = false;
        boolean progress = false;
        SpaceRequest totalBPD = new SpaceRequest();
        SpaceRequest returnRequest = new SpaceRequest(this, null);
        Extent remaining = new Extent(available);
        while (!(bodyAlternatives == null || progress && exceeded)) {
            SpaceRequest request;
            int fit = bodyAlternatives.getFit();
            if (fit == 0) {
                request = bodyAlternatives.getFirstBodyRequest();
                totalBPD.appendRequest(request);
                returnRequest.incorporateRequest(request);
                returnRequest.setCursor(this.walker.getCurrentNode());
                this.lastChildRequest = request;
                long consumed = totalBPD.getOptimum();
                remaining.setBPD(available.bpd - consumed);
                bodyAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                progress = true;
                alternatives.setFit(0);
            } else if (fit == 2) {
                bodyAlternatives = this.generateNextAlternatives(composeInfo, remaining);
            } else if (fit == 1) {
                if (!progress) {
                    request = bodyAlternatives.getFirstBodyRequest();
                    totalBPD.appendRequest(request);
                    returnRequest.setCursor(this.walker.getCurrentNode());
                    returnRequest.incorporateRequest(request);
                    this.lastChildRequest = request;
                    exceeded = true;
                    progress = true;
                    alternatives.setFit(1);
                } else {
                    exceeded = true;
                }
            }
            if (bodyAlternatives == null && !progress) {
                alternatives.setFit(2);
            }
            returnRequest.setRequestorArea(blockArea);
            alternatives.addSpaceRequest(returnRequest);
        }
        return alternatives;
    }

    private SpaceAlternatives generateNextAlternatives(ComposeInfo composeInfo, Extent available) {
        SpaceAlternatives alternatives;
        if (this.walker.getCurrentNode() != null) {
            FLOListItem currentItem = (FLOListItem)((Object)this.walker.getCurrentNode());
            alternatives = currentItem.composeItemRequest(composeInfo, available, this.lastChildRequest, this.startSep - this.labelSep, available.ipd - this.startSep);
            if (alternatives.getFit() == 2) {
                this.walker.getNext();
                this.skipToAnItemFormatter();
                this.lastChildRequest = null;
            }
        } else {
            alternatives = null;
        }
        return alternatives;
    }

    protected void initialize() {
        MiscellaneousProperty listProperties = this.properties.getMiscellaneousProperty();
        this.startSepLen = listProperties.getProvisionalDistanceBetweenStarts();
        this.labelSepLen = listProperties.getProvisionalLabelSeparation();
        this.isInitialized = true;
    }

    private void setLengths(ComposeInfo composeInfo) {
        long[] units = composeInfo.getUnitsForProperties(this.properties);
        this.startSep = this.startSepLen.getNormalizedLength(units);
        this.labelSep = this.labelSepLen.getNormalizedLength(units);
    }

    private void skipToAnItemFormatter() {
        Node currentNode = this.walker.getCurrentNode();
        while (currentNode != null && !(currentNode instanceof FLOListItem)) {
            currentNode = this.walker.getNext();
            this.lastChildRequest = null;
        }
    }

    public String toString() {
        return "[fo:list-block " + Integer.toHexString(this.hashCode()) + "]";
    }
}

