/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOFlow;
import com.ibm.xsl.composer.flo.FLOLayoutMasterSet;
import com.ibm.xsl.composer.flo.FLORegion;
import com.ibm.xsl.composer.flo.FLOStaticContent;
import com.ibm.xsl.composer.flo.PageMaster;
import com.ibm.xsl.composer.flo.PageMasterIterator;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.PaginationAndLayoutProperty;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOPageSequence
extends FLOElement {
    private FLOFlow flow;
    private PaginationAndLayoutProperty palp;
    private int currentPageComposed = 0;
    private int lastPageNumber = 0;
    private ComposeInfo requestComposeInfo;
    private Extent available;
    private GeneralArea pageViewport;
    private GeneralArea pageReference;
    private GeneralArea regionReference;
    private PageMaster master;
    private FLOPoint bodyLocation;
    private short masterReferenceOrientation;
    private FLORegion flowRegion;
    private WritingMode writingMode;

    public FLOPageSequence(DocumentImpl dom) {
        this(dom, "page-sequence");
    }

    public FLOPageSequence(DocumentImpl dom, String elementName) {
        super(dom, elementName);
    }

    public void appendPages(Context context, AreaTree tree, PageMasterIterator pmi, FLOLayoutMasterSet floLayoutMasterSet) {
        this.checkInit();
        this.palp = this.properties.getPaginationAndLayoutProperty();
        int initialPageNumber = 1;
        boolean referenceOrientation = false;
        this.setCurrentPageComposed(initialPageNumber);
        SpaceRequest flowRequest = null;
        boolean exhausted = false;
        while (!exhausted) {
            if (this.flow != null) {
                this.master = pmi.getNextPageMaster(floLayoutMasterSet, this.currentPageComposed, this.flow, this.lastPageNumber);
                this.getPageArea(context, this.master);
                SpaceAlternatives flowAlternatives = this.flow.composeRequest(this.requestComposeInfo, this.available, flowRequest);
                exhausted = flowAlternatives.getFit() == 2;
                SpaceRequest flowRequestHold = flowRequest = flowAlternatives.getFirstBodyRequest();
                PageMaster masterHold = this.master;
                while (!exhausted) {
                    GeneralArea body;
                    this.master = pmi.getNextPageMaster(floLayoutMasterSet, this.currentPageComposed, this.flow, this.lastPageNumber);
                    this.getPageArea(context, this.master);
                    flowAlternatives = this.flow.composeRequest(this.requestComposeInfo, this.available, flowRequest);
                    boolean bl = exhausted = flowAlternatives.getFit() == 2;
                    if (exhausted) {
                        this.lastPageNumber = this.currentPageComposed;
                        this.master = pmi.getNextPageMaster(floLayoutMasterSet, this.currentPageComposed, this.flow, this.lastPageNumber);
                        this.getPageArea(context, this.master);
                        body = this.flow.composeAreas(this.requestComposeInfo, this.available, flowRequestHold);
                        body.setLocation(this.bodyLocation);
                        this.regionReference.addChild(body);
                        this.getStaticContentArea(context, this.master);
                        tree.append(this.pageViewport);
                        this.incrementCurrentPageComposed();
                        continue;
                    }
                    this.getPageArea(context, masterHold);
                    body = this.flow.composeAreas(this.requestComposeInfo, this.available, flowRequestHold);
                    body.setLocation(this.bodyLocation);
                    this.regionReference.addChild(body);
                    if (this.currentPageComposed == 1) {
                        this.getStaticContentArea(context, masterHold);
                    } else {
                        this.getStaticContentArea(context, this.master);
                    }
                    tree.append(this.pageViewport);
                    this.incrementCurrentPageComposed();
                    flowRequestHold = flowRequest = flowAlternatives.getFirstBodyRequest();
                    masterHold = this.master;
                }
            }
            if (this.flow != null) continue;
            exhausted = true;
        }
    }

    private void checkInit() {
        if (this.flow == null) {
            this.initialize();
        }
    }

    public int getCurrentPageComposed() {
        return this.currentPageComposed;
    }

    public String getMasterName() {
        this.palp = this.properties.getPaginationAndLayoutProperty();
        return this.palp.getMasterName();
    }

    private void getPageArea(Context context, PageMaster master) {
        if (this.flow != null) {
            String regionBodyName = this.flow.getFlowName();
            this.writingMode = master.getWritingMode();
            this.masterReferenceOrientation = master.getReferenceOrientation();
            this.pageViewport = master.getViewportArea(context);
            this.pageReference = master.getReferenceArea(context);
            this.flowRegion = master.getRegion(regionBodyName, context);
            if (this.flowRegion != null) {
                short bodyReferenceOrientation = this.flowRegion.getReferenceOrientation();
                if (bodyReferenceOrientation != 0) {
                    this.masterReferenceOrientation = bodyReferenceOrientation;
                }
                GeneralArea regionViewport = this.flowRegion.getViewportArea(context);
                this.regionReference = this.flowRegion.getReferenceArea(context);
                this.bodyLocation = this.flowRegion.getLocation();
                if (bodyReferenceOrientation != 0) {
                    this.regionReference.setLocation(this.bodyLocation);
                }
                this.pageViewport.addChild(this.pageReference);
                this.pageReference.addChild(regionViewport);
                regionViewport.addChild(this.regionReference);
                this.available = this.flowRegion.getExtent();
                if (this.masterReferenceOrientation == 90 || this.masterReferenceOrientation == 270) {
                    this.available.invert();
                }
                this.requestComposeInfo = new ComposeInfo(context, this.available);
                this.requestComposeInfo.setWritingMode(this.writingMode);
                this.requestComposeInfo.setReferenceOrientation(this.masterReferenceOrientation);
                this.requestComposeInfo.pageNumber = this.currentPageComposed;
            }
        }
    }

    private void getStaticContentArea(Context context, PageMaster masterHold) {
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        boolean exhausted = false;
        while (child != null) {
            FLOStaticContent staticContent;
            String sideRegionName;
            FLORegion sideRegion;
            if (child instanceof FLOStaticContent && (sideRegion = masterHold.getRegion(sideRegionName = (staticContent = (FLOStaticContent)((Object)child)).getFlowName(), context)) != null) {
                short sideReferenceOrientation = sideRegion.getReferenceOrientation();
                this.masterReferenceOrientation = this.master.getReferenceOrientation();
                if (sideReferenceOrientation != 0) {
                    this.masterReferenceOrientation = sideReferenceOrientation;
                }
                GeneralArea sideArea = sideRegion.getReferenceArea(context);
                FLOPoint sideLocation = sideRegion.getLocation();
                if (sideReferenceOrientation != 0) {
                    sideArea.setLocation(sideLocation);
                }
                Extent sideAvailable = sideRegion.getExtent();
                ComposeInfo sideComposeInfo = new ComposeInfo(context, sideAvailable);
                sideComposeInfo.setReferenceOrientation(this.masterReferenceOrientation);
                sideComposeInfo.pageNumber = this.currentPageComposed;
                SpaceAlternatives sideAlternatives = staticContent.composeRequest(sideComposeInfo, sideAvailable, null);
                boolean bl = exhausted = sideAlternatives.getFit() == 2;
                if (!exhausted) {
                    SpaceRequest sideRequest = sideAlternatives.getFirstBodyRequest();
                    GeneralArea sideRegionArea = staticContent.composeAreas(sideComposeInfo, sideAvailable, sideRequest);
                    sideRegionArea.setLocation(sideLocation);
                    sideArea.addChild(sideRegionArea);
                    this.pageReference.addChild(sideArea);
                }
            }
            child = walker.getNext();
        }
    }

    public void incrementCurrentPageComposed() {
        ++this.currentPageComposed;
    }

    private void initialize() {
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        while (child != null) {
            if (child instanceof FLOFlow && this.flow == null) {
                this.flow = (FLOFlow)((Object)child);
            }
            child = walker.getNext();
        }
    }

    public void setCurrentPageComposed(int pageIndex) {
        this.currentPageComposed = pageIndex;
    }
}

