/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.ReferenceBehavior;
import com.ibm.xsl.composer.areas.ViewportBehavior;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.properties.LayoutRelatedProperty;
import com.ibm.xsl.composer.properties.MarginProperty;
import com.ibm.xsl.composer.properties.PaginationAndLayoutProperty;
import org.apache.xerces.dom.DocumentImpl;

public class FLORegion
extends FLOElement {
    private long marginTop;
    private long marginBottom;
    private long marginLeft;
    private long marginRight;
    private MarginProperty margin;
    private PaginationAndLayoutProperty palp;
    private long bpd;
    private long ipd;
    private FLOPoint location = new FLOPoint();
    private short referenceOrientation;

    public FLORegion(DocumentImpl dom) {
        this(dom, "region-body");
    }

    public FLORegion(DocumentImpl dom, String elementName) {
        super(dom, elementName);
        this.palp = this.properties.getPaginationAndLayoutProperty();
        this.palp.setFlowName("flo-" + FLODocument.stripQualifier(elementName));
    }

    public Extent getExtent() {
        return new Extent(this.bpd, this.ipd);
    }

    public String getFlowName(Context context) {
        this.init(context);
        return this.palp.getFlowName();
    }

    public FLOPoint getLocation() {
        return new FLOPoint(this.location);
    }

    public long getMarginBottom(long[] units) {
        this.marginBottom = this.margin.getMarginBottom().getNormalizedLength(units);
        return this.marginBottom;
    }

    public long getMarginLeft(long[] units) {
        this.marginLeft = this.margin.getMarginLeft().getNormalizedLength(units);
        return this.marginLeft;
    }

    public long getMarginRight(long[] units) {
        this.marginRight = this.margin.getMarginRight().getNormalizedLength(units);
        return this.marginRight;
    }

    public long getMarginTop(long[] units) {
        this.marginTop = this.margin.getMarginTop().getNormalizedLength(units);
        return this.marginTop;
    }

    public boolean getPrecedence() {
        return this.palp.getPrecedence();
    }

    public GeneralArea getReferenceArea(Context context) {
        GeneralArea regionArea = new GeneralArea();
        regionArea.setProgenitor(this);
        regionArea.addBehavior(new ReferenceBehavior());
        ComposeInfo composeInfo = new ComposeInfo(context, this.getExtent());
        regionArea.initializeTraits(composeInfo, this.properties);
        regionArea.extendContentArea(this.getLocation(), this.getExtent());
        return regionArea;
    }

    public short getReferenceOrientation() {
        LayoutRelatedProperty lrp = this.properties.getLayoutRelatedProperty();
        this.referenceOrientation = lrp.getReferenceOrientation();
        return this.referenceOrientation;
    }

    public String getRegionName(Context context) {
        this.init(context);
        return this.palp.getRegionName();
    }

    public long getSideRegionExtent(long[] units) {
        CSSLength extentLength = new CSSLength(this.palp.getExtent());
        long extent = extentLength.getNormalizedLength(units);
        return extent;
    }

    public GeneralArea getViewportArea(Context context) {
        GeneralArea regionArea = new GeneralArea();
        regionArea.setProgenitor(this);
        regionArea.addBehavior(new ViewportBehavior());
        ComposeInfo composeInfo = new ComposeInfo(context, this.getExtent());
        regionArea.initializeTraits(composeInfo, this.properties);
        regionArea.extendContentArea(this.getLocation(), this.getExtent());
        return regionArea;
    }

    private void init(Context context) {
        if (this.margin == null) {
            this.margin = this.properties.getMarginProperty();
        }
    }

    public void setExtent(long bpd, long ipd) {
        this.bpd = bpd;
        this.ipd = ipd;
    }

    public void setLocation(FLOPoint inLocation) {
        this.location.setLocation(inLocation.before, inLocation.start);
    }
}

