/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.ReferenceBehavior;
import com.ibm.xsl.composer.areas.ViewportBehavior;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOFlow;
import com.ibm.xsl.composer.flo.FLOLayoutMasterSet;
import com.ibm.xsl.composer.flo.FLORegion;
import com.ibm.xsl.composer.flo.PageMaster;
import com.ibm.xsl.composer.flo.PageMasterIterator;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.properties.LayoutRelatedProperty;
import com.ibm.xsl.composer.properties.MarginProperty;
import com.ibm.xsl.composer.properties.PaginationAndLayoutProperty;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;
import java.util.HashMap;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOSimplePageMaster
extends FLOElement
implements PageMaster,
PageMasterIterator {
    private HashMap regions = new HashMap();
    private long pageReferenceHeight;
    private long pageReferenceWidth;
    private long[] units;
    private short referenceOrientation;

    public FLOSimplePageMaster(DocumentImpl dom) {
        this(dom, "simple-page-master");
    }

    public FLOSimplePageMaster(DocumentImpl dom, String elementName) {
        super(dom, elementName);
    }

    private void calculateRegionSize() {
        long endHeight;
        long afterWidth;
        long beforeWidth;
        long startHeight;
        long bodyWidth;
        long bodyHeight;
        FLORegion body = (FLORegion)this.regions.get("flo-region-body");
        FLORegion before = (FLORegion)this.regions.get("flo-region-before");
        FLORegion after = (FLORegion)this.regions.get("flo-region-after");
        FLORegion start = (FLORegion)this.regions.get("flo-region-start");
        FLORegion end = (FLORegion)this.regions.get("flo-region-end");
        FLOPoint location = new FLOPoint(0L, 0L);
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            bodyHeight = this.pageReferenceWidth - this.getMarginTop(body) - this.getMarginBottom(body) - this.getRegionExtent(before) - this.getRegionExtent(after);
            bodyWidth = this.pageReferenceHeight - this.getMarginTop(body) - this.getMarginBottom(body) - this.getRegionExtent(start) - this.getRegionExtent(end);
        } else {
            bodyHeight = this.pageReferenceHeight - this.getMarginTop(body) - this.getMarginBottom(body) - this.getRegionExtent(before) - this.getRegionExtent(after);
            bodyWidth = this.pageReferenceWidth - this.getMarginLeft(body) - this.getMarginRight(body) - this.getRegionExtent(start) - this.getRegionExtent(end);
        }
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            long hold = bodyHeight;
            bodyHeight = bodyWidth;
            bodyWidth = hold;
        }
        location.start = this.getRegionExtent(start) + this.getMarginLeft(body);
        location.before = this.getRegionExtent(before) + this.getMarginTop(body);
        this.setRegionLocation(body, location);
        this.setRegionExtent(body, bodyHeight, bodyWidth);
        long startWidth = this.getRegionExtent(start);
        location.start = 0L;
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            if (!this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                startHeight = this.pageReferenceWidth;
                location.before = 0L;
            } else if (this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                startHeight = this.pageReferenceWidth - this.getRegionExtent(before);
                location.before = this.getRegionExtent(before);
            } else if (!this.getRegionPrecedence(before) && this.getRegionPrecedence(after)) {
                startHeight = this.pageReferenceWidth - this.getRegionExtent(after);
                location.before = 0L;
            } else {
                startHeight = this.pageReferenceWidth - this.getRegionExtent(before) - this.getRegionExtent(after);
                location.before = this.getRegionExtent(before);
            }
        } else if (!this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
            startHeight = this.pageReferenceHeight;
            location.before = 0L;
        } else if (this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
            startHeight = this.pageReferenceHeight - this.getRegionExtent(before);
            location.before = this.getRegionExtent(before);
        } else if (!this.getRegionPrecedence(before) && this.getRegionPrecedence(after)) {
            startHeight = this.pageReferenceHeight - this.getRegionExtent(after);
            location.before = 0L;
        } else {
            startHeight = this.pageReferenceHeight - this.getRegionExtent(before) - this.getRegionExtent(after);
            location.before = this.getRegionExtent(before);
        }
        this.setRegionLocation(start, location);
        this.setRegionExtent(start, startHeight, startWidth);
        long beforeHeight = this.getRegionExtent(before);
        location.before = 0L;
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            if (!this.getRegionPrecedence(before)) {
                beforeWidth = this.pageReferenceHeight - this.getRegionExtent(start) - this.getRegionExtent(end);
                location.start = this.getRegionExtent(start);
            } else {
                beforeWidth = this.pageReferenceHeight;
                location.start = 0L;
            }
        } else if (!this.getRegionPrecedence(before)) {
            beforeWidth = this.pageReferenceWidth - this.getRegionExtent(start) - this.getRegionExtent(end);
            location.start = this.getRegionExtent(start);
        } else {
            beforeWidth = this.pageReferenceWidth;
            location.start = 0L;
        }
        this.setRegionLocation(before, location);
        this.setRegionExtent(before, beforeHeight, beforeWidth);
        long afterHeight = this.getRegionExtent(after);
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            location.before = this.pageReferenceWidth - this.getRegionExtent(after);
            if (!this.getRegionPrecedence(after)) {
                afterWidth = this.pageReferenceHeight - this.getRegionExtent(start) - this.getRegionExtent(end);
                location.start = this.getRegionExtent(start);
            } else {
                afterWidth = this.pageReferenceHeight;
                location.start = 0L;
            }
        } else {
            location.before = this.pageReferenceHeight - this.getRegionExtent(after);
            if (!this.getRegionPrecedence(after)) {
                afterWidth = this.pageReferenceWidth - this.getRegionExtent(start) - this.getRegionExtent(end);
                location.start = this.getRegionExtent(start);
            } else {
                afterWidth = this.pageReferenceWidth;
                location.start = 0L;
            }
        }
        this.setRegionLocation(after, location);
        this.setRegionExtent(after, afterHeight, afterWidth);
        long endWidth = this.getRegionExtent(end);
        if (this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            location.start = this.pageReferenceHeight - this.getRegionExtent(end);
            if (!this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceWidth;
                location.before = 0L;
            } else if (this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceWidth - this.getRegionExtent(before);
                location.before = this.getRegionExtent(before);
            } else if (!this.getRegionPrecedence(before) && this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceWidth - this.getRegionExtent(after);
                location.before = 0L;
            } else {
                endHeight = this.pageReferenceWidth - this.getRegionExtent(before) - this.getRegionExtent(after);
                location.before = this.getRegionExtent(before);
            }
        } else {
            location.start = this.pageReferenceWidth - this.getRegionExtent(end);
            if (!this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceHeight;
                location.before = 0L;
            } else if (this.getRegionPrecedence(before) && !this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceHeight - this.getRegionExtent(before);
                location.before = this.getRegionExtent(before);
            } else if (!this.getRegionPrecedence(before) && this.getRegionPrecedence(after)) {
                endHeight = this.pageReferenceHeight - this.getRegionExtent(after);
                location.before = 0L;
            } else {
                endHeight = this.pageReferenceHeight - this.getRegionExtent(before) - this.getRegionExtent(after);
                location.before = this.getRegionExtent(before);
            }
        }
        this.setRegionLocation(end, location);
        this.setRegionExtent(end, endHeight, endWidth);
    }

    private void checkInit(Context context) {
        if (this.regions.isEmpty()) {
            this.initialize(context);
        }
    }

    public void floFound(boolean wasFound) {
        if (!wasFound) {
            String message = "The simple page master does not specify a region for the flow.\nProcessing cannot terminate.";
            throw new IllegalArgumentException(message);
        }
    }

    private long getMarginBottom(FLORegion body) {
        long marginBottom = 0L;
        if (body != null) {
            marginBottom = body.getMarginBottom(this.units);
        }
        return marginBottom;
    }

    private long getMarginLeft(FLORegion body) {
        long marginLeft = 0L;
        if (body != null) {
            marginLeft = body.getMarginLeft(this.units);
        }
        return marginLeft;
    }

    private long getMarginRight(FLORegion body) {
        long marginRight = 0L;
        if (body != null) {
            marginRight = body.getMarginRight(this.units);
        }
        return marginRight;
    }

    private long getMarginTop(FLORegion body) {
        long marginTop = 0L;
        if (body != null) {
            marginTop = body.getMarginTop(this.units);
        }
        return marginTop;
    }

    public String getMasterName() {
        PaginationAndLayoutProperty palp = this.properties.getPaginationAndLayoutProperty();
        return palp.getMasterName();
    }

    public PageMaster getNextPageMaster(FLOLayoutMasterSet floLayoutMasterSet, int currentPageNumber, FLOFlow flow, int lastPageNumber) {
        return this;
    }

    public GeneralArea getReferenceArea(Context context) {
        GeneralArea reference = new GeneralArea();
        reference.setProgenitor(this);
        reference.addBehavior(new ReferenceBehavior());
        CSSExtent pageSize = context.getPageSize();
        ComposeInfo composeInfo = new ComposeInfo(context, new Extent(pageSize.height, pageSize.width));
        composeInfo.setReferenceOrientation(this.referenceOrientation);
        this.units = composeInfo.getUnitsForProperties(this.properties);
        MarginProperty margin = this.properties.getMarginProperty();
        long marginTop = margin.getMarginTop().getNormalizedLength(this.units);
        long marginBottom = margin.getMarginBottom().getNormalizedLength(this.units);
        long marginLeft = margin.getMarginLeft().getNormalizedLength(this.units);
        long marginRight = margin.getMarginRight().getNormalizedLength(this.units);
        this.pageReferenceHeight = pageSize.height - marginTop - marginBottom;
        this.pageReferenceWidth = pageSize.width - marginLeft - marginRight;
        this.calculateRegionSize();
        reference.initializeTraits(composeInfo, this.properties);
        reference.extendContentArea(new FLOPoint(0L, 0L), new Extent(this.pageReferenceHeight, this.pageReferenceWidth));
        return reference;
    }

    public short getReferenceOrientation() {
        LayoutRelatedProperty lrp = this.properties.getLayoutRelatedProperty();
        this.referenceOrientation = lrp.getReferenceOrientation();
        return this.referenceOrientation;
    }

    public FLORegion getRegion(String name, Context context) {
        this.checkInit(context);
        return (FLORegion)this.regions.get(name);
    }

    private long getRegionExtent(FLORegion region) {
        long extent = 0L;
        if (region != null) {
            extent = region.getSideRegionExtent(this.units);
        }
        return extent;
    }

    private boolean getRegionPrecedence(FLORegion region) {
        boolean precedence = false;
        if (region != null) {
            precedence = region.getPrecedence();
        }
        return precedence;
    }

    public GeneralArea getViewportArea(Context context) {
        GeneralArea viewport = new GeneralArea();
        viewport.setProgenitor(this);
        viewport.addBehavior(new ViewportBehavior(true));
        CSSExtent pageSize = context.getPageSize();
        ComposeInfo composeInfo = new ComposeInfo(context, new Extent(pageSize.height, pageSize.width));
        composeInfo.setReferenceOrientation(this.referenceOrientation);
        viewport.initializeTraits(composeInfo, this.properties);
        viewport.extendContentArea(new FLOPoint(0L, 0L), new Extent(pageSize.height, pageSize.width));
        return viewport;
    }

    public WritingMode getWritingMode() {
        WritingModeRelatedProperty wmp = this.properties.getWritingModeRelatedProperty();
        WritingMode wm = wmp.getWritingMode();
        return wm;
    }

    private void initialize(Context context) {
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        while (child != null) {
            if (child instanceof FLORegion) {
                FLORegion region = (FLORegion)((Object)child);
                this.regions.put(region.getRegionName(context), region);
                this.regions.put(region.getFlowName(context), region);
            }
            child = walker.getNext();
            this.calculateRegionSize();
        }
    }

    private void setRegionExtent(FLORegion region, long bpd, long ipd) {
        if (region != null) {
            region.setExtent(bpd, ipd);
        }
    }

    private void setRegionLocation(FLORegion region, FLOPoint location) {
        if (region != null) {
            region.setLocation(location);
        }
    }
}

