/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.LineArea;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Space;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BlockAndLineRelatedProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.w3c.dom.Node;

public class InlinePacker
implements FLO {
    private Node parentFO;
    private Node startingChildFO;
    private ChildNodeWalker walker;
    private SpaceRequest previousSpaceRequest;
    protected PropertyMap textProperties;
    protected short lineStackingStrategy;

    protected void adjustReturnRequestForLineStackingStrategy(ComposeInfo composeInfo, LineArea inlineArea, SpaceRequest returnRequest) {
        FontProperty fp = this.textProperties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        if (this.lineStackingStrategy == 2 || this.lineStackingStrategy == 0) {
            Extent areaSize = inlineArea.getExtent();
            returnRequest.setAreaOptimum(areaSize.bpd);
        } else {
            returnRequest.setAreaOptimum(font.getHeight());
        }
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        LineArea inlineArea = (LineArea)chosenRequest.getRequestorArea();
        SpaceRequest totalWidth = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Iterator wordRequests = chosenRequest.getChildRequests();
        Extent childAllocation = new Extent(allocated);
        while (wordRequests.hasNext()) {
            SpaceRequest wordRequest = (SpaceRequest)wordRequests.next();
            FLO wordNode = (FLO)wordRequest.getFormatter();
            childAllocation.setIPD(wordRequest.getOptimum());
            GeneralArea wordArea = wordNode.composeAreas(composeInfo, childAllocation, wordRequest);
            curPoint.start += wordRequest.getBeforeOptimum();
            if (wordArea.startSpace != null) {
                curPoint.start += wordArea.startSpace.getOptimum();
            }
            wordArea.setLocation(curPoint);
            totalWidth.appendRequest(wordRequest);
            curPoint.start = totalWidth.getAreaOptimum() + totalWidth.getAfterOptimum();
        }
        inlineArea.setContentBPD(this.determineAmountUsedInBPD(inlineArea, chosenRequest));
        inlineArea.setContentIPD(totalWidth.getAreaOptimum());
        inlineArea.alignChildren();
        return inlineArea;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        if (priorRequest != null) {
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
            this.previousSpaceRequest = priorRequest.getLastChildRequest();
        } else {
            this.walker = new ChildNodeWalker(this.parentFO);
            if (this.startingChildFO != null) {
                this.walker.setCurrentNode(this.startingChildFO);
            } else {
                this.walker.getNext();
            }
            this.previousSpaceRequest = null;
        }
        LineArea inlineArea = new LineArea();
        this.initializeBehaviorsForDecorating(composeInfo, inlineArea);
        SpaceAlternatives alternatives = new SpaceAlternatives();
        alternatives.setFit(2);
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        boolean exceeded = false;
        boolean progress = false;
        SpaceRequest totalIPD = new SpaceRequest();
        SpaceRequest returnRequest = new SpaceRequest(this, inlineArea);
        Extent remaining = new Extent(available);
        SpaceAlternatives nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
        Extent childAllocation = new Extent(remaining);
        while (!(nextAlternatives == null || progress && exceeded)) {
            GeneralArea childArea;
            FLO childFLO;
            SpaceRequest request;
            int fit = nextAlternatives.getFit();
            if (fit == 0) {
                long consumed;
                progress = true;
                request = nextAlternatives.getFirstBodyRequest();
                totalIPD.appendRequest(request);
                returnRequest.incorporateRequest(request);
                returnRequest.setCursor(this.walker.getCurrentNode());
                this.previousSpaceRequest = request;
                childFLO = (FLO)request.getFormatter();
                childAllocation.setIPD(request.getOptimum());
                childArea = childFLO.composeAreas(composeInfo, childAllocation, request);
                inlineArea.addChild(childArea);
                composeInfo.isPageDirty = true;
                inlineArea.extendContentArea(curPoint, childArea.getExtent());
                curPoint.start = consumed = totalIPD.getOptimum();
                remaining.setIPD(available.ipd - consumed);
                if (request.getBreakAfter() >= 2) {
                    returnRequest.addBreakAfter(request.getBreakAfter());
                    break;
                }
                nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                continue;
            }
            if (fit == 2) {
                nextAlternatives = this.generateNextAlternatives(composeInfo, remaining);
                continue;
            }
            if (fit != 1) continue;
            if (!progress) {
                exceeded = true;
                progress = true;
                request = nextAlternatives.getFirstBodyRequest();
                totalIPD.appendRequest(request);
                returnRequest.incorporateRequest(request);
                returnRequest.setCursor(this.walker.getCurrentNode());
                this.previousSpaceRequest = request;
                childFLO = (FLO)request.getFormatter();
                childArea = childFLO.composeAreas(composeInfo, remaining, request);
                inlineArea.addChild(childArea);
                composeInfo.isPageDirty = true;
                inlineArea.extendContentArea(curPoint, childArea.getExtent());
                continue;
            }
            exceeded = true;
        }
        alternatives.setFit(0);
        returnRequest.setBefore(Space.EMPTY);
        returnRequest.setAfter(Space.EMPTY);
        this.adjustReturnRequestForLineStackingStrategy(composeInfo, inlineArea, returnRequest);
        if (this.determineSpaceAvailableInConstrainedDirection(available) < returnRequest.getOptimum()) {
            alternatives.setFit(1);
        }
        if (!progress) {
            alternatives.setFit(2);
        }
        alternatives.addSpaceRequest(returnRequest);
        return alternatives;
    }

    public static final String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nPackages: com.ibm.xsl.composer...\n(C) Copyright IBM Corp. 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    protected long determineAmountUsedInBPD(GeneralArea inlineArea, SpaceRequest inlineRequest) {
        return inlineRequest.getAreaOptimum();
    }

    protected long determineSpaceAvailableInConstrainedDirection(Extent available) {
        return available.bpd;
    }

    private SpaceAlternatives generateNextAlternatives(ComposeInfo composeInfo, Extent available) {
        SpaceAlternatives alternatives;
        if (this.walker.getCurrentNode() != null && this.walker.getCurrentNode() instanceof InlineContent) {
            alternatives = ((FLO)((Object)this.walker.getCurrentNode())).composeRequest(composeInfo, available, this.previousSpaceRequest);
            if (alternatives.getFit() == 2) {
                this.walker.getNext();
                this.previousSpaceRequest = null;
            }
        } else {
            alternatives = null;
        }
        return alternatives;
    }

    public ListIterator getProgeny() {
        return null;
    }

    public void initialize(Node parent, Node startingChild, PropertyMap textProperties) {
        this.parentFO = parent;
        this.startingChildFO = startingChild;
        this.textProperties = textProperties;
        BlockAndLineRelatedProperty balrp = textProperties.getBlockAndLineRelatedProperty();
        this.lineStackingStrategy = balrp.getLineStackingStrategy();
    }

    protected void initializeBehaviorsForDecorating(ComposeInfo composeInfo, LineArea inlineArea) {
    }

    public Node nextNode() {
        return this.walker.getCurrentNode();
    }

    public void reset() {
    }

    public String toString() {
        return "<inlinePacker>" + Integer.toHexString(this.hashCode()) + "</inlinePacker>";
    }
}

