/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.BackgroundBehavior;
import com.ibm.xsl.composer.areas.BackgroundImageBehavior;
import com.ibm.xsl.composer.areas.BorderBehavior;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.LineArea;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.InlinePacker;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.FontProperty;

public class NestedInlinePacker
extends InlinePacker {
    private BorderPaddingBackgroundProperty bp;

    protected void addBehaviors(GeneralArea inlineArea) {
        this.bp = this.textProperties.getBorderPaddingBackgroundProperty();
        if (!this.bp.isTransparent()) {
            inlineArea.addBehavior(new BackgroundBehavior());
        }
        if (this.bp.getBackgroundImage() != null) {
            inlineArea.addBehavior(new BackgroundImageBehavior());
        }
        inlineArea.addBehavior(new BorderBehavior());
    }

    protected void adjustReturnRequestForLineStackingStrategy(ComposeInfo composeInfo, LineArea inlineArea, SpaceRequest returnRequest) {
        if (this.lineStackingStrategy == 2 || this.lineStackingStrategy == 0) {
            long[] units = composeInfo.getUnitsForProperties(this.textProperties);
            long returnIPD = returnRequest.getAreaOptimum() + this.bp.getBorderStartWidth().getNormalizedLength(units) + this.bp.getBorderEndWidth().getNormalizedLength(units) + this.bp.getPaddingStart().getNormalizedLength(units) + this.bp.getPaddingEnd().getNormalizedLength(units);
            returnRequest.setAreaOptimum(returnIPD);
        } else {
            FontProperty fp = this.textProperties.getFontProperty();
            ExtendedFont font = composeInfo.context.getExtendedFont(fp);
            returnRequest.setAreaOptimum(font.getHeight());
        }
    }

    protected long determineAmountUsedInBPD(GeneralArea inlineArea, SpaceRequest inlineRequest) {
        Extent areaSize = inlineArea.getExtent();
        inlineArea.adjustAvailable(areaSize);
        return areaSize.bpd;
    }

    protected long determineSpaceAvailableInConstrainedDirection(Extent available) {
        return available.ipd;
    }

    protected void initializeBehaviorsForDecorating(ComposeInfo composeInfo, LineArea inlineArea) {
        this.addBehaviors(inlineArea);
        inlineArea.initializeTraits(composeInfo, this.textProperties);
        inlineArea.setProgenitor(this);
    }

    public String toString() {
        return "[nestedInlinePacker " + Integer.toHexString(this.hashCode()) + "]";
    }
}

