/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.csstypes.BorderStyle;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSColorWithAlpha;
import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.table.AreaEdge;
import com.ibm.xsl.composer.flo.table.CollapsingBorderBehavior;
import com.ibm.xsl.composer.flo.table.FLOTable;
import com.ibm.xsl.composer.flo.table.FLOTableCell;
import com.ibm.xsl.composer.flo.table.FLOTableColumn;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRow;
import com.ibm.xsl.composer.flo.table.RelationFilter;
import com.ibm.xsl.composer.flo.table.TableBorderBehavior;
import com.ibm.xsl.composer.flo.table.TableLayer;
import com.ibm.xsl.composer.flo.table.TableProgressionDirection;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TableBorderBehaviorCollapse
implements TableBorderBehavior {
    private Context context;
    private FLOTable table;
    private boolean distributeErrorFollowing;
    private static Object[] ov = new Object[6];

    TableBorderBehaviorCollapse(Context context, FLOTable table, boolean distributeErrorFollowing) {
        this.context = context;
        this.table = table;
        this.distributeErrorFollowing = distributeErrorFollowing;
    }

    private void addSegments(Set segments, Set relations, AreaEdge edge) {
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            FLOTableElement e = (FLOTableElement)it.next();
            segments.add(new BorderSegment(e, edge));
        }
    }

    private static BorderSegment chooseCell(Set segments, boolean first) {
        BorderSegment c1 = null;
        BorderSegment c2 = null;
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (!TableBorderBehaviorCollapse.isCellLayer(bs.fo)) continue;
            if (c1 == null) {
                c1 = bs;
                continue;
            }
            if (c2 == null) {
                c2 = bs;
                continue;
            }
            throw new IllegalStateException();
        }
        BorderSegment c = null;
        if (c1 != null) {
            c = c2 != null ? TableBorderBehaviorCollapse.chooseSegment(c1, c2, first) : c1;
        }
        return c;
    }

    private static BorderSegment chooseLayerWithPrecedence(BorderSegment bs1, BorderSegment bs2) {
        TableLayer l2;
        TableLayer l1 = bs1.getLayer();
        int d = l1.compareTo(l2 = bs2.getLayer());
        if (d > 0) {
            return bs1;
        }
        if (d < 0) {
            return bs2;
        }
        return null;
    }

    private static BorderSegment chooseSegment(BorderSegment bs1, BorderSegment bs2, boolean first) {
        BorderSegment bs = null;
        if (first) {
            if (bs1.edge == AreaEdge.END || bs1.edge == AreaEdge.AFTER) {
                bs = bs1;
            } else if (bs2.edge == AreaEdge.END || bs2.edge == AreaEdge.AFTER) {
                bs = bs2;
            }
        } else if (bs1.edge == AreaEdge.START || bs1.edge == AreaEdge.BEFORE) {
            bs = bs1;
        } else if (bs2.edge == AreaEdge.START || bs2.edge == AreaEdge.BEFORE) {
            bs = bs2;
        }
        return bs;
    }

    private static BorderSegment chooseTable(Set segments) {
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (!TableBorderBehaviorCollapse.isTableLayer(bs.fo)) continue;
            return bs;
        }
        return null;
    }

    private void collapseColSegments() {
        Iterator it = this.table.getRows().iterator();
        while (it.hasNext()) {
            this.collapseInColProgression(((FLOTableRow)it.next()).getCells());
        }
    }

    private void collapseExternalSegment(Set segments, BorderSegment bs) {
        BorderSegment bs1 = TableBorderBehaviorCollapse.chooseCell(segments, true);
        BorderSegment bs2 = TableBorderBehaviorCollapse.chooseTable(segments);
        if (bs1 == null || bs2 == null) {
            throw new IllegalStateException();
        }
        this.distributeExternalSegmentTraits(bs, bs1, bs2);
    }

    private void collapseInColProgression(List cells) {
        this.collapseInProgression(cells, TableProgressionDirection.COL);
    }

    private void collapseInProgression(List cells, TableProgressionDirection dir) {
        boolean first = true;
        FLOTableCell c = null;
        Iterator it = cells.iterator();
        while (it.hasNext() || first) {
            if ((!first || c == null) && it.hasNext()) {
                c = (FLOTableCell)it.next();
            } else {
                first = false;
            }
            if (c == null) continue;
            Set segments = this.extractSegments(c, dir, first);
            this.collapseSegment(segments, TableBorderBehaviorCollapse.computeBorderPrecedence(segments));
        }
    }

    private void collapseInRowProgression(List cells) {
        this.collapseInProgression(cells, TableProgressionDirection.ROW);
    }

    private void collapseInternalSegment(Set segments, BorderSegment bs) {
        BorderSegment bs1 = TableBorderBehaviorCollapse.chooseCell(segments, true);
        BorderSegment bs2 = TableBorderBehaviorCollapse.chooseCell(segments, false);
        if (bs1 == null || bs2 == null) {
            throw new IllegalStateException();
        }
        this.distributeInternalSegmentTraits(bs, bs1, bs2);
    }

    private void collapseRowSegments() {
        Iterator it = this.table.getColumns().iterator();
        while (it.hasNext()) {
            this.collapseInRowProgression(((FLOTableColumn)it.next()).getCells());
        }
    }

    private void collapseSegment(Set segments, BorderSegment bs) {
        if (TableBorderBehaviorCollapse.isInternalSegment(segments)) {
            this.collapseInternalSegment(segments, bs);
        } else {
            this.collapseExternalSegment(segments, bs);
        }
    }

    private static int compareBorderStylePrecedence(BorderSegment bs1, BorderSegment bs2) {
        int s2;
        int s1 = CollapsingBorderBehavior.mapBorderStyleToPrecedence(TableBorderBehaviorCollapse.getBorderStyleForEdge(bs1.bp, bs1.edge));
        if (s1 < (s2 = CollapsingBorderBehavior.mapBorderStyleToPrecedence(TableBorderBehaviorCollapse.getBorderStyleForEdge(bs2.bp, bs2.edge)))) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        return 0;
    }

    private static int compareBorderWidthPrecedence(BorderSegment bs1, BorderSegment bs2) {
        long w2;
        long w1 = TableBorderBehaviorCollapse.getBorderWidthForEdge(bs1.bp, bs1.edge, bs1.getUnits());
        if (w1 < (w2 = TableBorderBehaviorCollapse.getBorderWidthForEdge(bs2.bp, bs2.edge, bs2.getUnits()))) {
            return -1;
        }
        if (w1 > w2) {
            return 1;
        }
        return 0;
    }

    private static int compareHashCodes(Object o1, Object o2) {
        int h2;
        int h1 = o1.hashCode();
        if (h1 < (h2 = o2.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    private static BorderSegment computeBorderPrecedence(Set segments) {
        if (segments.size() == 0) {
            throw new IllegalArgumentException();
        }
        BorderSegment bs = TableBorderBehaviorCollapse.computeBorderPrecedenceStep1(segments);
        if (bs == null && (bs = TableBorderBehaviorCollapse.computeBorderPrecedenceStep2(segments)) == null && (bs = TableBorderBehaviorCollapse.computeBorderPrecedenceStep3(segments)) == null && (bs = TableBorderBehaviorCollapse.computeBorderPrecedenceStep4(segments)) == null) {
            throw new IllegalStateException();
        }
        return bs;
    }

    private static BorderSegment computeBorderPrecedenceStep1(Set segments) {
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (!TableBorderBehaviorCollapse.isBorderStyleHidden(bs.bp, bs.edge)) continue;
            return bs;
        }
        return null;
    }

    private static BorderSegment computeBorderPrecedenceStep2(Set segments) {
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (TableBorderBehaviorCollapse.isBorderStyleNone(bs.bp, bs.edge)) continue;
            return null;
        }
        return TableBorderBehaviorCollapse.chooseCell(segments, true);
    }

    private static BorderSegment computeBorderPrecedenceStep3(Set segments) {
        WidthComparable wc2;
        WidthComparable wc1;
        TreeSet<WidthComparable> ss = new TreeSet<WidthComparable>();
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (TableBorderBehaviorCollapse.isBorderStyleNone(bs.bp, bs.edge)) continue;
            ss.add(new WidthComparable(bs));
        }
        Object[] objectArray = ov;
        synchronized (objectArray) {
            Object[] v = ss.toArray(ov);
            wc1 = v.length > 0 ? (WidthComparable)v[0] : null;
            wc2 = v.length > 1 ? (WidthComparable)v[1] : null;
        }
        if (wc1 == null) {
            throw new IllegalStateException();
        }
        if (wc2 != null && TableBorderBehaviorCollapse.compareBorderWidthPrecedence(wc1.bs, wc2.bs) == 0) {
            return null;
        }
        return wc1.bs;
    }

    private static BorderSegment computeBorderPrecedenceStep4(Set segments) {
        StyleComparable sc2;
        StyleComparable sc1;
        TreeSet<StyleComparable> ss = new TreeSet<StyleComparable>();
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            BorderSegment bs = (BorderSegment)it.next();
            if (TableBorderBehaviorCollapse.isBorderStyleNone(bs.bp, bs.edge)) continue;
            ss.add(new StyleComparable(bs));
        }
        Object[] objectArray = ov;
        synchronized (objectArray) {
            Object[] v = ss.toArray(ov);
            sc1 = v.length > 0 ? (StyleComparable)v[0] : null;
            sc2 = v.length > 1 ? (StyleComparable)v[1] : null;
        }
        if (sc1 == null) {
            throw new IllegalStateException();
        }
        if (sc2 != null && TableBorderBehaviorCollapse.compareBorderStylePrecedence(sc1.bs, sc2.bs) == 0) {
            BorderSegment bs = TableBorderBehaviorCollapse.chooseLayerWithPrecedence(sc1.bs, sc2.bs);
            if (bs == null) {
                bs = TableBorderBehaviorCollapse.chooseCell(segments, true);
            }
            return bs;
        }
        return sc1.bs;
    }

    private static AreaEdge computeSegmentEdge(TableProgressionDirection dir, boolean firstSegment) {
        AreaEdge edge = dir == TableProgressionDirection.COL ? (firstSegment ? AreaEdge.START : AreaEdge.END) : (dir == TableProgressionDirection.ROW ? (firstSegment ? AreaEdge.BEFORE : AreaEdge.AFTER) : null);
        return edge;
    }

    private void distributeExternalSegmentTraits(BorderSegment bs, BorderSegment bs1, BorderSegment bs2) {
        FLOTableCell c = (FLOTableCell)bs1.fo;
        FLOTable t = (FLOTable)bs2.fo;
        CSSColorWithAlpha color = TableBorderBehaviorCollapse.getBorderColorForEdge(bs.bp, bs.edge);
        long w = TableBorderBehaviorCollapse.toPixels(this.context, TableBorderBehaviorCollapse.getBorderWidthForEdge(bs.bp, bs.edge, bs.getUnits()));
        short style = TableBorderBehaviorCollapse.getBorderStyleForEdge(bs.bp, bs.edge);
        c.setBorderTraits(bs1.edge, color, TableBorderBehaviorCollapse.fromPixels(this.context, w), w != 0L ? style : (short)0);
        t.setBorderTraits(bs2.edge, CSSColorWithAlpha.TRANSPARENT, 0L, 0);
    }

    private void distributeInternalSegmentTraits(BorderSegment bs, BorderSegment bs1, BorderSegment bs2) {
        long w1;
        FLOTableCell c1 = (FLOTableCell)bs1.fo;
        FLOTableCell c2 = (FLOTableCell)bs2.fo;
        CSSColorWithAlpha color = TableBorderBehaviorCollapse.getBorderColorForEdge(bs.bp, bs.edge);
        long w = TableBorderBehaviorCollapse.toPixels(this.context, TableBorderBehaviorCollapse.getBorderWidthForEdge(bs.bp, bs.edge, bs.getUnits()));
        short style = TableBorderBehaviorCollapse.getBorderStyleForEdge(bs.bp, bs.edge);
        long w2 = w1 = w / 2L;
        long wr = w % 2L;
        if (this.distributeErrorFollowing) {
            w2 += wr;
        } else {
            w1 += wr;
        }
        c1.setBorderTraits(bs1.edge, color, TableBorderBehaviorCollapse.fromPixels(this.context, w1), w1 != 0L ? style : (short)0);
        c2.setBorderTraits(bs2.edge, color, TableBorderBehaviorCollapse.fromPixels(this.context, w2), w2 != 0L ? style : (short)0);
    }

    private Set extractSegments(FLOTableCell cell, TableProgressionDirection dir, boolean firstSegment) {
        EdgeRelationFilter rf;
        AreaEdge e;
        FLOTableCell c2;
        HashSet s = new HashSet();
        FLOTableCell c1 = cell;
        FLOTableCell fLOTableCell = c2 = firstSegment ? null : cell.getAdjacent(dir, true);
        if (c1 != null) {
            e = TableBorderBehaviorCollapse.computeSegmentEdge(dir, firstSegment);
            rf = new EdgeRelationFilter(c1, e);
            this.addSegments(s, c1.getRelations(rf), e);
        }
        if (c2 != null) {
            e = TableBorderBehaviorCollapse.computeSegmentEdge(dir, firstSegment ^ true);
            rf = new EdgeRelationFilter(c2, e);
            this.addSegments(s, c2.getRelations(rf), e);
        }
        return s;
    }

    private static long fromPixels(Context context, long d) {
        return d * context.getUnitsPerPixel();
    }

    private static CSSColorWithAlpha getBorderColorForEdge(BorderPaddingBackgroundProperty bp, AreaEdge edge) {
        CSSColor c;
        if (edge == AreaEdge.BEFORE) {
            c = bp.getBorderBeforeColor();
        } else if (edge == AreaEdge.AFTER) {
            c = bp.getBorderAfterColor();
        } else if (edge == AreaEdge.START) {
            c = bp.getBorderStartColor();
        } else if (edge == AreaEdge.END) {
            c = bp.getBorderEndColor();
        } else {
            throw new IllegalArgumentException();
        }
        return c instanceof CSSColorWithAlpha ? (CSSColorWithAlpha)c : new CSSColorWithAlpha(c);
    }

    private static short getBorderStyleForEdge(BorderPaddingBackgroundProperty bp, AreaEdge edge) {
        short s;
        if (edge == AreaEdge.BEFORE) {
            s = bp.getBorderBeforeStyle();
        } else if (edge == AreaEdge.AFTER) {
            s = bp.getBorderAfterStyle();
        } else if (edge == AreaEdge.START) {
            s = bp.getBorderStartStyle();
        } else if (edge == AreaEdge.END) {
            s = bp.getBorderEndStyle();
        } else {
            throw new IllegalArgumentException();
        }
        return s;
    }

    private static long getBorderWidthForEdge(BorderPaddingBackgroundProperty bp, AreaEdge edge, long[] units) {
        CSSLength l;
        if (edge == AreaEdge.BEFORE) {
            l = bp.getBorderBeforeWidth();
        } else if (edge == AreaEdge.AFTER) {
            l = bp.getBorderAfterWidth();
        } else if (edge == AreaEdge.START) {
            l = bp.getBorderStartWidth();
        } else if (edge == AreaEdge.END) {
            l = bp.getBorderEndWidth();
        } else {
            throw new IllegalArgumentException();
        }
        return l.getNormalizedLength(units);
    }

    private static boolean isBorderStyleHidden(BorderPaddingBackgroundProperty bp, AreaEdge edge) {
        return TableBorderBehaviorCollapse.isBorderStyleType(bp, edge, 1);
    }

    private static boolean isBorderStyleNone(BorderPaddingBackgroundProperty bp, AreaEdge edge) {
        return TableBorderBehaviorCollapse.isBorderStyleType(bp, edge, 0);
    }

    private static boolean isBorderStyleType(BorderPaddingBackgroundProperty bp, AreaEdge edge, int type) {
        return TableBorderBehaviorCollapse.getBorderStyleForEdge(bp, edge) == type;
    }

    private static boolean isCellLayer(FLOElement fo) {
        return TableLayer.getLayerForFormattingObject(fo) == TableLayer.CELL;
    }

    private static boolean isInternalSegment(Set segments) {
        return TableBorderBehaviorCollapse.chooseTable(segments) == null;
    }

    private static boolean isTableLayer(FLOElement fo) {
        return TableLayer.getLayerForFormattingObject(fo) == TableLayer.TABLE;
    }

    public void performBehavior() {
        this.collapseColSegments();
        this.collapseRowSegments();
    }

    private static long toPixels(Context context, long d) {
        return d / context.getUnitsPerPixel();
    }

    private class BorderSegment {
        FLOTableElement fo;
        AreaEdge edge;
        BorderPaddingBackgroundProperty bp;
        private long[] units;

        BorderSegment(FLOTableElement fo, AreaEdge edge) {
            this.fo = fo;
            this.edge = edge;
            this.bp = fo.getProperties().getBorderPaddingBackgroundProperty();
        }

        private long[] computeUnits() {
            ExtendedFont f = TableBorderBehaviorCollapse.this.context.getExtendedFont(this.fo.getProperties().getFontProperty());
            this.units = this.initUnits(new long[6], TableBorderBehaviorCollapse.this.context.getUnitsPerPoint(), f.getCharacterHeight('x'), f.getSize() * TableBorderBehaviorCollapse.this.context.getUnitsPerPoint(), TableBorderBehaviorCollapse.this.context.getUnitsPerPixel(), 0L, 0L);
            return this.units;
        }

        TableLayer getLayer() {
            return TableLayer.getLayerForFormattingObject(this.fo);
        }

        long[] getUnits() {
            return this.units != null ? this.units : this.computeUnits();
        }

        private long[] initUnits(long[] units, long uPt, long uEx, long uEm, long uPx, long uPc, long uEq) {
            units[1] = uPt;
            units[3] = uEx;
            units[2] = uEm;
            units[0] = uPx;
            units[4] = uPc;
            units[5] = uEq;
            return units;
        }

        public String toString() {
            return "SEG[" + this.fo.toString() + "," + this.edge.getName() + "]: " + TableBorderBehaviorCollapse.toPixels(TableBorderBehaviorCollapse.this.context, TableBorderBehaviorCollapse.getBorderWidthForEdge(this.bp, this.edge, this.getUnits())) + "px " + BorderStyle.getStyleName(TableBorderBehaviorCollapse.getBorderStyleForEdge(this.bp, this.edge)) + " " + TableBorderBehaviorCollapse.getBorderColorForEdge(this.bp, this.edge).toHexColor();
        }
    }

    private static class WidthComparable
    implements Comparable {
        BorderSegment bs;

        WidthComparable(BorderSegment bs) {
            this.bs = bs;
        }

        public int compareTo(Object object) {
            WidthComparable wc = (WidthComparable)object;
            int d = TableBorderBehaviorCollapse.compareBorderWidthPrecedence(wc.bs, this.bs);
            if (d == 0) {
                return TableBorderBehaviorCollapse.compareHashCodes(wc.bs, this.bs);
            }
            return d;
        }
    }

    private static class StyleComparable
    implements Comparable {
        BorderSegment bs;

        StyleComparable(BorderSegment bs) {
            this.bs = bs;
        }

        public int compareTo(Object object) {
            StyleComparable sc = (StyleComparable)object;
            int d = TableBorderBehaviorCollapse.compareBorderStylePrecedence(sc.bs, this.bs);
            if (d == 0) {
                return TableBorderBehaviorCollapse.compareHashCodes(sc.bs, this.bs);
            }
            return d;
        }
    }

    private static class EdgeRelationFilter
    implements RelationFilter {
        private FLOTableCell cell;
        private AreaEdge edge;

        EdgeRelationFilter(FLOTableCell cell, AreaEdge edge) {
            this.cell = cell;
            this.edge = edge;
        }

        public boolean exclude(FLOTableElement e) {
            return this.cell.hasCommonEdge(e, this.edge) ^ true;
        }
    }
}

