/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.flo.FLOElement;
import java.util.Hashtable;

public class TableLayer
implements Comparable {
    private static final int LAYER_TABLE = 0;
    private static final int LAYER_COLGRP = 1;
    private static final int LAYER_COL = 2;
    private static final int LAYER_ROWGRP = 3;
    private static final int LAYER_ROW = 4;
    private static final int LAYER_CELL = 5;
    private static String[] layerNames = new String[]{"table", "column group", "column", "row group", "row", "cell"};
    public static final TableLayer TABLE = new TableLayer(0);
    public static final TableLayer COLGRP = new TableLayer(1);
    public static final TableLayer COL = new TableLayer(2);
    public static final TableLayer ROWGRP = new TableLayer(3);
    public static final TableLayer ROW = new TableLayer(4);
    public static final TableLayer CELL = new TableLayer(5);
    private int layer;
    private static Hashtable foNameToLayer = new Hashtable(8);

    static {
        foNameToLayer.put("table", TABLE);
        foNameToLayer.put("table-column-group", COLGRP);
        foNameToLayer.put("table-column", COL);
        foNameToLayer.put("table-header", ROWGRP);
        foNameToLayer.put("table-footer", ROWGRP);
        foNameToLayer.put("table-body", ROWGRP);
        foNameToLayer.put("table-row", ROW);
        foNameToLayer.put("table-cell", CELL);
    }

    private TableLayer(int layer) {
        this.layer = layer;
    }

    public int compareTo(Object object) {
        int p2;
        int p1 = this.getPrecedence();
        if (p1 < (p2 = ((TableLayer)object).getPrecedence())) {
            return -1;
        }
        if (p1 > p2) {
            return 1;
        }
        return 0;
    }

    public static TableLayer getLayerForFormattingObject(FLOElement fo) {
        return (TableLayer)foNameToLayer.get(fo.getLocalName());
    }

    public String getName() {
        return layerNames[this.layer];
    }

    public int getPrecedence() {
        return this.layer;
    }

    public String toString() {
        return "[TableLayer:" + this.getName() + "]";
    }
}

