/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.framework;

import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOFlow;
import com.ibm.xsl.composer.flo.FLOText;
import com.ibm.xsl.composer.framework.EndElementHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class FLOTreeBuilder {
    private final Stack wmStack = new Stack();
    private boolean isAllowedPCDATA = false;
    private Node curNode;
    private FLODocument document;
    private Map endElementHandlers;

    public FLOTreeBuilder() {
        this.wmStack.push(new WritingMode());
    }

    public void addEndElementHandler(String eltName, EndElementHandler eh) {
        if (this.endElementHandlers == null) {
            this.endElementHandlers = new HashMap();
        }
        this.endElementHandlers.put(eltName, eh);
    }

    private void appendNode(Node newNode) {
        this.curNode.appendChild(newNode);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isAllowedPCDATA) {
            String text = new String(ch, start, length);
            FLOText textNode = (FLOText)((Object)this.document.createTextNode(text, this.curNode));
            this.appendNode((Node)((Object)textNode));
        }
    }

    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        this.maybePerformEndElementProcessing((Element)this.curNode);
        this.curNode = this.curNode.getParentNode();
        if (this.curNode instanceof FLOFlow) {
            this.isAllowedPCDATA = false;
        }
        this.wmStack.pop();
    }

    private EndElementHandler findEndElementHandler(Element e) {
        return this.endElementHandlers != null ? (EndElementHandler)this.endElementHandlers.get(e.getTagName()) : null;
    }

    public Document getDocument() {
        return this.document;
    }

    public FLODocument getFLODocument() {
        return this.document;
    }

    private void maybePerformEndElementProcessing(Element e) {
        EndElementHandler eh = this.findEndElementHandler(e);
        if (eh != null) {
            eh.endElement(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        this.appendNode(pi);
    }

    public void removeEndElementHandler(String eltName) {
        if (this.endElementHandlers != null) {
            this.endElementHandlers.remove(eltName);
        }
    }

    public void setAttribute(String uri, String localName, String qualifiedName, String value) throws SAXException {
        Element elt = (Element)this.curNode;
        if (uri == null || uri.length() == 0) {
            if (uri == null || uri.length() == 0) {
                elt.setAttribute(qualifiedName, value);
            } else {
                elt.setAttributeNS(uri, localName, value);
            }
        } else {
            elt.setAttributeNS(uri, localName, value);
        }
        String WRITING_MODE = "writing-mode";
        if (localName.toLowerCase().equals("writing-mode")) {
            WritingMode curWM = new WritingMode();
            curWM.setWritingMode(value);
            this.wmStack.pop();
            this.wmStack.push(curWM);
        }
    }

    public void startDocument() throws SAXException {
        this.document = new FLODocument();
        this.document.setTreeBuilder(this);
        this.curNode = this.document;
    }

    public void startElement(String uri, String localName, String qualifiedName) throws SAXException {
        Element elt = uri == null || uri.length() == 0 ? this.document.createElement(qualifiedName) : this.document.createElementNS(uri, qualifiedName);
        this.appendNode(elt);
        this.curNode = elt;
        if (elt instanceof BlockContent) {
            this.isAllowedPCDATA = true;
        }
        WritingMode wmParent = (WritingMode)this.wmStack.peek();
        this.wmStack.push(wmParent);
        if (elt instanceof FLOElement) {
            ((FLOElement)((Object)elt)).setParentWritingMode(wmParent);
        }
    }
}

