/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.csstypes.BorderStyle;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.java2d.TBRL;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;

public abstract class J2DFourEdgeBorder {
    public final int BUTT = 1;
    public final int MITER = 2;
    protected final short TOP_EDGE = 1;
    protected final short BOTTOM_EDGE = (short)2;
    protected final short RIGHT_EDGE = (short)3;
    protected final short LEFT_EDGE = (short)4;
    protected final short TOP_DEPENDANCY = 1;
    protected final short BOTTOM_DEPENDANCY = (short)2;
    protected final short RIGHT_DEPENDANCY = (short)3;
    protected final short LEFT_DEPENDANCY = (short)4;
    int borderWidth;
    Color color;
    boolean all = true;
    protected boolean topEdge;
    protected int topWidth;
    protected Color topColor;
    protected boolean bottomEdge;
    protected int bottomWidth;
    protected Color bottomColor;
    protected boolean rightEdge;
    protected int rightWidth;
    protected Color rightColor;
    protected boolean leftEdge;
    protected int leftWidth;
    protected Color leftColor;
    protected int dependantTopStyle;
    protected int dependantBottomStyle;
    protected int dependantRightStyle;
    protected int dependantLeftStyle;

    public J2DFourEdgeBorder() {
        this.resetAllEdges();
    }

    public J2DFourEdgeBorder(int borderWidth, CSSColor color) {
        this.resetAllEdges();
        this.borderWidth = borderWidth;
        CSSColor c = new CSSColor();
        this.color = new Color(c.red, c.green, c.blue);
        this.all = true;
    }

    public int determineCornerStyle(int edge, int corner) {
        if (edge == 1 || edge == 2 ? (corner == 3 ? this.isMiter(this.dependantRightStyle) : corner == 4 && this.isMiter(this.dependantLeftStyle)) : (edge == 4 || edge == 3) && (corner == 1 ? this.isMiter(this.dependantTopStyle) : corner == 2 && this.isMiter(this.dependantBottomStyle))) {
            return 2;
        }
        return 1;
    }

    public int determineLineWidth(int width) {
        return width;
    }

    public Insets getBorderWidths() {
        return new Insets(this.topWidth, this.leftWidth, this.bottomWidth, this.rightWidth);
    }

    boolean isEdgeExists(int edge) {
        boolean exists = false;
        switch (edge) {
            case 1: {
                if (this.dependantTopStyle != 0 && this.topWidth > 0) {
                    exists = true;
                }
            }
            case 2: {
                if (this.dependantBottomStyle != 0 && this.bottomWidth > 0) {
                    exists = true;
                }
            }
            case 3: {
                if (this.dependantRightStyle != 0 && this.rightWidth > 0) {
                    exists = true;
                }
            }
            case 4: {
                if (this.dependantLeftStyle == 0 || this.leftWidth <= 0) break;
                exists = true;
            }
        }
        return exists;
    }

    public boolean isMiter(int style) {
        return style == 9 || style == 8 || style == 6 || style == 7;
    }

    protected abstract void paintBorder(Graphics2D var1, int var2, int var3, int var4, int var5);

    public String printCornerStyle(int cornerStyle) {
        switch (cornerStyle) {
            case 1: {
                return "butt";
            }
            case 2: {
                return "miter";
            }
        }
        return "corner style " + cornerStyle + " is not a valid style";
    }

    public void resetAllEdges() {
        this.borderWidth = 0;
        CSSColor c = new CSSColor();
        this.color = new Color(c.red, c.green, c.blue);
        this.all = false;
        this.dependantTopStyle = 0;
        this.dependantBottomStyle = 0;
        this.dependantRightStyle = 0;
        this.dependantLeftStyle = 0;
        this.resetTopEdge();
        this.resetBottomEdge();
        this.resetRightEdge();
        this.resetLeftEdge();
    }

    public void resetBottomEdge() {
        this.bottomEdge = false;
        this.bottomWidth = 0;
        CSSColor c = new CSSColor();
        this.bottomColor = new Color(c.red, c.green, c.blue);
    }

    public void resetLeftEdge() {
        this.leftEdge = false;
        this.leftWidth = 0;
        CSSColor c = new CSSColor();
        this.leftColor = new Color(c.red, c.green, c.blue);
    }

    public void resetRightEdge() {
        this.rightEdge = false;
        this.rightWidth = 0;
        CSSColor c = new CSSColor();
        this.rightColor = new Color(c.red, c.green, c.blue);
    }

    public void resetTopEdge() {
        this.topEdge = false;
        this.topWidth = 0;
        CSSColor c = new CSSColor();
        this.topColor = new Color(c.red, c.green, c.blue);
    }

    public void setBottomEdge(CSSColor bottomColor, int bottomWidth) {
        this.bottomEdge = true;
        this.bottomColor = new Color(bottomColor.red, bottomColor.green, bottomColor.blue);
        this.bottomWidth = bottomWidth;
    }

    public void setDependancies(TBRL tbrl) {
        if (tbrl.isTopSet()) {
            this.topWidth = tbrl.getTopWidth();
            this.dependantTopStyle = tbrl.getTopStyle();
        }
        if (tbrl.isBottomSet()) {
            this.bottomWidth = tbrl.getBottomWidth();
            this.dependantBottomStyle = tbrl.getBottomStyle();
        }
        if (tbrl.isRightSet()) {
            this.rightWidth = tbrl.getRightWidth();
            this.dependantRightStyle = tbrl.getRightStyle();
        }
        if (tbrl.isLeftSet()) {
            this.leftWidth = tbrl.getLeftWidth();
            this.dependantLeftStyle = tbrl.getLeftStyle();
        }
    }

    public void setLeftEdge(CSSColor leftColor, int leftWidth) {
        this.leftEdge = true;
        this.leftColor = new Color(leftColor.red, leftColor.green, leftColor.blue);
        this.leftWidth = leftWidth;
    }

    public void setRightEdge(CSSColor rightColor, int rightWidth) {
        this.rightEdge = true;
        this.rightColor = new Color(rightColor.red, rightColor.green, rightColor.blue);
        this.rightWidth = rightWidth;
    }

    public void setTopEdge(CSSColor topColor, int topWidth) {
        this.topEdge = true;
        this.topColor = new Color(topColor.red, topColor.green, topColor.blue);
        this.topWidth = topWidth;
    }

    public String toString() {
        return "dependantTopStyle:" + BorderStyle.getStyleName(this.dependantTopStyle) + " dependantBottomStyle:" + BorderStyle.getStyleName(this.dependantBottomStyle) + " dependantRightStyle:" + BorderStyle.getStyleName(this.dependantRightStyle) + " dependantLeftStyle:" + BorderStyle.getStyleName(this.dependantLeftStyle);
    }
}

