/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.Vector;

public class ColumnSpecs {
    private Vector columnWidths = new Vector();
    private boolean widthsFixed = false;
    private boolean widthsNormalized = false;

    public void addColumn(CSSLength width) {
        this.widthsFixed = true;
        CSSLength nextWidth = new CSSLength(width);
        this.columnWidths.addElement(width);
    }

    public void addColumn(PropertyMap properties) {
        this.widthsNormalized = false;
        CSSLength width = new CSSLength();
        this.columnWidths.addElement(width);
    }

    public int getColumnCount() {
        return this.columnWidths.size();
    }

    public CSSLength getWidth(int columnNumber) {
        if (!this.widthsFixed && !this.widthsNormalized) {
            this.normalizeWidths();
        }
        return (CSSLength)this.columnWidths.elementAt(columnNumber);
    }

    private void normalizeWidths() {
        int count = this.getColumnCount();
        int i = 0;
        while (i < count) {
            CSSLength width = (CSSLength)this.columnWidths.elementAt(i);
            width.setLength(100 / count, (short)8);
            ++i;
        }
    }
}

