/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

public class Extent {
    public static final int BPD = 1;
    public static final int IPD = 2;
    public long bpd;
    public long ipd;

    public Extent() {
    }

    public Extent(long bpd, long ipd) {
        this.setExtent(bpd, ipd);
    }

    public Extent(Extent extent) {
        this.copy(extent);
    }

    public void copy(Extent extent) {
        this.bpd = extent.bpd;
        this.ipd = extent.ipd;
    }

    public boolean doesFit(Extent extent) {
        return this.bpd >= extent.bpd && this.ipd >= extent.ipd;
    }

    public void ensureFit(Extent enclosure) {
        this.bpd = Math.max(this.bpd, enclosure.bpd);
        this.ipd = Math.max(this.ipd, enclosure.ipd);
    }

    public long getBPD() {
        return this.bpd;
    }

    public long getIPD() {
        return this.ipd;
    }

    public void incrementBPD(long increment) {
        this.bpd += increment;
    }

    public void incrementIPD(long increment) {
        this.ipd += increment;
    }

    public void invert() {
        long hold = this.ipd;
        this.ipd = this.bpd;
        this.bpd = hold;
    }

    public void replaceBPDIfLarger(long value) {
        if (value > this.bpd) {
            this.bpd = value;
        }
    }

    public void replaceIPDIfLarger(long value) {
        if (value > this.ipd) {
            this.ipd = value;
        }
    }

    public void reset() {
        this.bpd = 0L;
        this.ipd = 0L;
    }

    public void setBPD(long size) {
        this.bpd = size;
    }

    public void setExtent(long bpd, long ipd) {
        this.bpd = bpd;
        this.ipd = ipd;
    }

    public void setIPD(long size) {
        this.ipd = size;
    }

    public String toString() {
        return "<extent  bpd='" + this.bpd + "' ipd='" + this.ipd + "'/>";
    }
}

