/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

import com.ibm.xsl.composer.prim.SpaceRequest;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SpaceAlternatives {
    public static final int FIT = 0;
    public static final int NO_FIT = 1;
    public static final int EXHAUSTED = 2;
    private static final int LAST_FIT = 2;
    private static String[] fitNames = new String[]{"fit", "no_fit", "exhausted"};
    private int fit = 0;
    private Vector body = new Vector(1);
    private Vector floats = new Vector();
    private long labelStartIndent;
    private long bodyEndIndent;

    private void addRequest(Object body, Object floats) {
        this.body.addElement(body);
        this.floats.addElement(floats);
    }

    public void addSpaceRequest(SpaceRequest body) {
        this.addRequest(body, SpaceRequest.EMPTY);
    }

    public void addSpaceRequest(SpaceRequest body, SpaceRequest floats) {
        this.addRequest(body, floats);
    }

    public Iterator getBodyRequests() {
        return ((AbstractList)this.body).iterator();
    }

    public long getEndIndent() {
        return this.bodyEndIndent;
    }

    public SpaceRequest getFirstBodyRequest() {
        return (SpaceRequest)this.body.firstElement();
    }

    public SpaceRequest getFirstFloatRequest() {
        return (SpaceRequest)this.floats.firstElement();
    }

    public int getFit() {
        return this.fit;
    }

    public String getFitName() {
        String fitName = this.fit <= 2 ? fitNames[this.fit] : "invalid";
        return fitName;
    }

    public Iterator getFloatRequests() {
        return ((AbstractList)this.floats).iterator();
    }

    public SpaceRequest getLastBodyRequest() {
        return (SpaceRequest)this.body.lastElement();
    }

    public long getStartIndent() {
        return this.labelStartIndent;
    }

    public void setEndIndent(long indent) {
        this.bodyEndIndent = indent;
    }

    public void setFit(int fit) {
        this.fit = fit;
    }

    public void setStartIndent(long indent) {
        this.labelStartIndent = indent;
    }

    public String toString() {
        StringBuffer alternatives = new StringBuffer("<space-alternatives fit ='" + this.getFitName() + "'>");
        if (this.fit != 2) {
            Iterator bit = this.getBodyRequests();
            Iterator fit = this.getFloatRequests();
            int i = 0;
            while (bit.hasNext()) {
                SpaceRequest p = (SpaceRequest)bit.next();
                alternatives.append("<alternative number='" + i + "'><body>" + p + "</body>");
                alternatives.append("</alternative>");
                ++i;
            }
        }
        alternatives.append("</space-alternatives>");
        return alternatives.toString();
    }
}

