/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.prim.Size;
import com.ibm.xsl.composer.prim.Space;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SpaceRequest {
    public static final int BREAK_AUTO = 0;
    public static final int BREAK_COLUMN = 1;
    public static final int BREAK_PAGE = 2;
    public static final int BREAK_EVEN_PAGE = 3;
    public static final int BREAK_ODD_PAGE = 4;
    private int breakBefore = 0;
    private int breakAfter = 0;
    public Size area = new Size();
    public Space before = new Space();
    public Space after = new Space();
    private GeneralArea requestorArea;
    private Object flo;
    private Object cursor;
    private Vector childRequests = new Vector(1);
    public static final SpaceRequest EMPTY = new SpaceRequest(null, null);

    public SpaceRequest() {
        this(null, null);
    }

    public SpaceRequest(Object formatter, GeneralArea theRequestor) {
        this.flo = formatter;
        this.requestorArea = theRequestor;
    }

    public void addBreakAfter(int type) {
        if (this.breakAfter < type) {
            this.breakAfter = type;
        }
    }

    public void addBreakBefore(int type) {
        if (this.breakBefore < type) {
            this.breakBefore = type;
        }
    }

    public void addRequest(SpaceRequest childRequest) {
        this.childRequests.addElement(childRequest);
    }

    public void appendRequest(SpaceRequest addRequest) {
        this.area.sum(addRequest.area);
        Size interSpace = this.getInterSpace(addRequest);
        this.area.sum(interSpace);
        this.after.copy(addRequest.after);
    }

    public void copy(SpaceRequest request) {
        this.area.copy(request.area);
        this.before.copy(request.before);
        this.after.copy(request.after);
    }

    public long getAfterOptimum() {
        return this.after.getOptimum();
    }

    public long getAreaOptimum() {
        return this.area.optimum;
    }

    public long getBeforeOptimum() {
        return this.before.getOptimum();
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public Iterator getChildRequests() {
        return ((AbstractList)this.childRequests).iterator();
    }

    public Object getCursor() {
        return this.cursor;
    }

    public SpaceRequest getFirstChildRequest() {
        return (SpaceRequest)this.childRequests.firstElement();
    }

    public Object getFormatter() {
        return this.flo;
    }

    public Size getInterSpace(SpaceRequest afterRequest) {
        return this.after.combine(afterRequest.before);
    }

    public SpaceRequest getLastChildRequest() {
        return (SpaceRequest)this.childRequests.lastElement();
    }

    public long getOptimum() {
        return this.getBeforeOptimum() + this.getAfterOptimum() + this.area.optimum;
    }

    public GeneralArea getRequestorArea() {
        return this.requestorArea;
    }

    public void incorporateRequest(SpaceRequest childRequest) {
        this.appendRequest(childRequest);
        this.childRequests.addElement(childRequest);
    }

    public void incorporateRequestMax(SpaceRequest childRequest) {
        this.before.max(childRequest.before);
        this.area.max(childRequest.area);
        this.after.max(childRequest.after);
        this.childRequests.addElement(childRequest);
    }

    public boolean isAfterConditional() {
        return this.after.conditionality == 1;
    }

    public boolean isBeforeConditional() {
        return this.before.conditionality == 1;
    }

    public void setAfter(Space afterSpace) {
        this.after.copy(afterSpace);
    }

    public void setAreaMinimumOptimumMaximum(long minimum, long optimum, long maximum) {
        this.area.setRange(minimum, maximum, optimum);
    }

    public void setAreaOptimum(long size) {
        this.area.setScalar(size);
    }

    public void setBefore(Space beforeSpace) {
        this.before.copy(beforeSpace);
    }

    public void setCursor(Object newCursor) {
        this.cursor = newCursor;
    }

    public void setFLO(FLO flo) {
        this.flo = flo;
    }

    public void setRequestorArea(GeneralArea theRequestor) {
        this.requestorArea = theRequestor;
    }

    public String toString() {
        return "<space-request><before>" + this.before + "</before>" + "<area>" + this.area + "</area>" + "<after>" + this.after + "</after>" + "</space-request>";
    }
}

